/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.containers.customhandler;

import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.upgrades.OverclockerCard;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CardItemHandler
extends ItemStackHandler {
    public ItemStack stack;

    public CardItemHandler(int size, ItemStack itemStack) {
        super(size);
        this.stack = itemStack;
    }

    protected void onContentsChanged(int slot) {
        if (!this.stack.isEmpty()) {
            BaseCard.setInventory(this.stack, this);
        }
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.stack.getItem() instanceof CardEnergy) {
            return stack.getItem() instanceof OverclockerCard;
        }
        if (slot == 0) {
            return stack.getItem() instanceof BaseFilter;
        }
        return stack.getItem() instanceof OverclockerCard;
    }

    public int getSlotLimit(int slot) {
        if (this.stack.getItem() instanceof CardEnergy) {
            return 4;
        }
        if (slot == 0) {
            return 1;
        }
        return 4;
    }

    public void reSize(int size) {
        NonNullList newStacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.stacks.size(); ++i) {
            newStacks.set(i, (Object)((ItemStack)this.stacks.get(i)));
        }
        this.stacks = newStacks;
    }
}

