/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.events;

import com.direwolf20.laserio.common.network.data.NodeParticlesChemicalPayload;
import com.direwolf20.laserio.common.network.data.NodeParticlesFluidPayload;
import com.direwolf20.laserio.common.network.data.NodeParticlesPayload;
import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ParticleDataChemical;
import com.direwolf20.laserio.util.ParticleData;
import com.direwolf20.laserio.util.ParticleDataFluid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ServerTickHandler {
    private static List<ParticleData> particleList = new ArrayList<ParticleData>();
    private static List<ParticleDataFluid> particleListFluid = new ArrayList<ParticleDataFluid>();
    private static List<ParticleDataChemical> particleListChemical = new ArrayList<ParticleDataChemical>();

    @SubscribeEvent
    public static void handleTickEndEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            HashSet<Object> levels;
            if (!particleList.isEmpty()) {
                levels = new HashSet<Object>();
                for (ParticleData particleData : particleList) {
                    levels.add(particleData.fromData.node().getLevel(event.getServer()));
                    levels.add(particleData.toData.node().getLevel(event.getServer()));
                }
                for (Level level : levels) {
                    PacketDistributor.DIMENSION.with((Object)level.dimension()).send(new CustomPacketPayload[]{new NodeParticlesPayload(List.copyOf(particleList))});
                }
                particleList.clear();
            }
            if (!particleListFluid.isEmpty()) {
                levels = new HashSet();
                for (ParticleDataFluid particleDataFluid : particleListFluid) {
                    levels.add(particleDataFluid.fromData.node().getLevel(event.getServer()));
                    levels.add(particleDataFluid.toData.node().getLevel(event.getServer()));
                }
                for (Level level : levels) {
                    PacketDistributor.DIMENSION.with((Object)level.dimension()).send(new CustomPacketPayload[]{new NodeParticlesFluidPayload(List.copyOf(particleListFluid))});
                }
                particleListFluid.clear();
            }
            if (!particleListChemical.isEmpty()) {
                levels = new HashSet();
                for (ParticleDataChemical particleDataChemical : particleListChemical) {
                    levels.add(event.getServer().getLevel(particleDataChemical.fromData.node().dimension()));
                    levels.add(event.getServer().getLevel(particleDataChemical.toData.node().dimension()));
                }
                for (Level level : levels) {
                    PacketDistributor.DIMENSION.with((Object)level.dimension()).send(new CustomPacketPayload[]{new NodeParticlesChemicalPayload(List.copyOf(particleListChemical))});
                }
                particleListChemical.clear();
            }
        }
    }

    public static void addToList(ParticleData particleData) {
        particleList.add(particleData);
    }

    public static void addToListFluid(ParticleDataFluid particleData) {
        particleListFluid.add(particleData);
    }

    public static void addToListFluid(ParticleDataChemical particleData) {
        particleListChemical.add(particleData);
    }
}

