/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items;

import com.direwolf20.laserio.common.containers.CardHolderContainer;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.upgrades.OverclockerCard;
import com.direwolf20.laserio.common.items.upgrades.OverclockerNode;
import com.direwolf20.laserio.setup.Registration;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CardHolder
extends Item {
    public CardHolder() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (player.isShiftKeyDown()) {
            CardHolder.setActive(itemstack, !CardHolder.getActive(itemstack));
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        IItemHandler itemHandler = (IItemHandler)itemstack.getCapability(Capabilities.ItemHandler.ITEM, null);
        if (itemHandler != null) {
            ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardHolderContainer(windowId, playerInventory, player, itemstack, itemHandler), (Component)Component.translatable((String)"")), buf -> buf.writeItem(itemstack));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public boolean isFoil(ItemStack itemStack) {
        return CardHolder.getActive(itemStack);
    }

    public IItemHandler getItemHandler(ItemStack stack) {
        return (IItemHandler)stack.getData(Registration.CARD_HOLDER_HANDLER);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (CardHolder.getActive(stack)) {
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack cardStack = player.getInventory().getItem(i);
                    if (!(cardStack.getItem() instanceof BaseCard) && !(cardStack.getItem() instanceof BaseFilter) && !(cardStack.getItem() instanceof OverclockerCard) && !(cardStack.getItem() instanceof OverclockerNode)) continue;
                    CardHolder.addCardToInventory(stack, cardStack);
                }
            }
        }
    }

    public static ItemStack addCardToInventory(ItemStack cardHolder, ItemStack card) {
        if (card.getItem() instanceof BaseFilter && card.hasTag()) {
            return card;
        }
        IItemHandler handler = (IItemHandler)cardHolder.getCapability(Capabilities.ItemHandler.ITEM, null);
        if (handler == null) {
            return card;
        }
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            int maxSize;
            ItemStack stackInSlot = handler.getStackInSlot(i);
            if (stackInSlot.isEmpty()) {
                emptySlots.add(i);
            }
            if (stackInSlot.isEmpty() || !ItemStack.isSameItemSameTags((ItemStack)stackInSlot, (ItemStack)card)) continue;
            int j = stackInSlot.getCount() + card.getCount();
            if (j <= (maxSize = 64)) {
                card.setCount(0);
                stackInSlot.setCount(j);
            } else if (stackInSlot.getCount() < maxSize) {
                card.shrink(maxSize - stackInSlot.getCount());
                stackInSlot.setCount(maxSize);
            }
            if (!card.isEmpty()) continue;
            return card;
        }
        if (emptySlots.isEmpty()) {
            return card;
        }
        handler.insertItem(((Integer)emptySlots.get(0)).intValue(), card.split(card.getCount()), false);
        return card;
    }

    public static UUID getUUID(ItemStack stack) {
        CompoundTag nbt = stack.getOrCreateTag();
        if (!nbt.hasUUID("UUID")) {
            UUID newId = UUID.randomUUID();
            nbt.putUUID("UUID", newId);
            return newId;
        }
        return nbt.getUUID("UUID");
    }

    public static boolean getActive(ItemStack stack) {
        CompoundTag compound = stack.getTag();
        if (compound == null || !compound.contains("active")) {
            return false;
        }
        return compound.getBoolean("active");
    }

    public static boolean setActive(ItemStack stack, boolean active) {
        if (!active) {
            stack.removeTagKey("active");
        } else {
            stack.getOrCreateTag().putBoolean("active", active);
        }
        return active;
    }
}

