/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items;

import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.blocks.baseblocks.BaseLaserBlock;
import com.direwolf20.laserio.util.DimBlockPos;
import com.direwolf20.laserio.util.VectorHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public class LaserWrench
extends Item {
    public static int maxDistance = 8;

    public LaserWrench() {
        super(new Item.Properties().stacksTo(1));
    }

    public static DimBlockPos storeConnectionPos(ItemStack wrench, Level level, BlockPos pos) {
        DimBlockPos dimBlockPos = new DimBlockPos(level, pos);
        wrench.getOrCreateTag().put("connectiondimpos", (Tag)dimBlockPos.toNBT());
        return dimBlockPos;
    }

    public static DimBlockPos getConnectionPos(ItemStack wrench, Level level) {
        CompoundTag compound = wrench.getOrCreateTag();
        if (level == null) {
            return null;
        }
        return !compound.contains("connectiondimpos") ? LaserWrench.storeConnectionPos(wrench, level, BlockPos.ZERO) : new DimBlockPos(compound.getCompound("connectiondimpos"));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack wrench = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return InteractionResultHolder.success((Object)wrench);
        }
        int range = 10;
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, ClipContext.Fluid.NONE, range);
        if ((lookingAt == null || !(level.getBlockState(VectorHelper.getLookingAt(player, wrench, range).getBlockPos()).getBlock() instanceof BaseLaserBlock)) && player.isShiftKeyDown()) {
            LaserWrench.storeConnectionPos(wrench, level, BlockPos.ZERO);
            return InteractionResultHolder.pass((Object)wrench);
        }
        BlockPos targetPos = lookingAt.getBlockPos();
        BlockEntity targetBE = level.getBlockEntity(targetPos);
        if (!(targetBE instanceof BaseLaserBE)) {
            return InteractionResultHolder.pass((Object)wrench);
        }
        if (player.isShiftKeyDown()) {
            if (targetPos.equals((Object)LaserWrench.getConnectionPos(wrench, level))) {
                LaserWrench.storeConnectionPos(wrench, level, BlockPos.ZERO);
                return InteractionResultHolder.pass((Object)wrench);
            }
            LaserWrench.storeConnectionPos(wrench, level, targetPos);
            return InteractionResultHolder.pass((Object)wrench);
        }
        DimBlockPos sourceDimPos = LaserWrench.getConnectionPos(wrench, level);
        BlockEntity sourceBE = sourceDimPos.getLevel(level.getServer()).getBlockEntity(sourceDimPos.blockPos);
        if (!(sourceBE instanceof BaseLaserBE)) {
            LaserWrench.storeConnectionPos(wrench, level, BlockPos.ZERO);
            return InteractionResultHolder.pass((Object)wrench);
        }
        if (targetBE instanceof LaserConnectorAdvBE) {
            LaserConnectorAdvBE targetAdv = (LaserConnectorAdvBE)targetBE;
            if (sourceBE instanceof LaserConnectorAdvBE) {
                LaserConnectorAdvBE sourceAdv = (LaserConnectorAdvBE)sourceBE;
                targetAdv.handleAdvancedConnection(sourceAdv);
                return InteractionResultHolder.success((Object)wrench);
            }
        }
        if (!targetPos.closerThan((Vec3i)sourceDimPos.blockPos, (double)maxDistance) || !level.equals(sourceDimPos.getLevel(level.getServer()))) {
            player.displayClientMessage((Component)Component.translatable((String)"message.laserio.wrenchrange", (Object[])new Object[]{maxDistance}), true);
            return InteractionResultHolder.pass((Object)wrench);
        }
        ((BaseLaserBE)targetBE).handleConnection((BaseLaserBE)sourceBE);
        return InteractionResultHolder.success((Object)wrench);
    }
}

