/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.cards;

import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.util.MiscTools;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BaseCard
extends Item {
    protected CardType CARDTYPE;

    public BaseCard() {
        super(new Item.Properties().stacksTo(1));
    }

    public CardType getCardType() {
        return this.CARDTYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, world, tooltip, flag);
        Minecraft mc = Minecraft.getInstance();
        if (world == null || mc.player == null) {
            return;
        }
        boolean sneakPressed = Screen.hasShiftDown();
        if (!sneakPressed) {
            tooltip.add((Component)Component.translatable((String)"laserio.tooltip.item.show_settings").withStyle(ChatFormatting.GRAY));
        } else {
            String currentMode = BaseCard.getNamedTransferMode(stack).toString();
            MutableComponent toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.mode", ChatFormatting.GRAY.getColor());
            int modeColor = ChatFormatting.GRAY.getColor();
            if (currentMode.equals("EXTRACT")) {
                modeColor = ChatFormatting.RED.getColor();
            } else if (currentMode.equals("INSERT")) {
                modeColor = ChatFormatting.GREEN.getColor();
            } else if (currentMode.equals("STOCK")) {
                modeColor = ChatFormatting.BLUE.getColor();
            } else if (currentMode.equals("SENSOR")) {
                modeColor = ChatFormatting.YELLOW.getColor();
            }
            toWrite.append((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.mode." + currentMode, modeColor));
            tooltip.add((Component)toWrite);
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.channel", ChatFormatting.GRAY.getColor());
            byte channel = BaseCard.getChannel(stack);
            toWrite.append((Component)MiscTools.tooltipMaker(String.valueOf(channel), LaserNodeBERender.colors[channel].getRGB()));
            tooltip.add((Component)toWrite);
            byte sneakyMode = BaseCard.getSneaky(stack);
            if (sneakyMode != -1) {
                toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.sneaky", ChatFormatting.GRAY.getColor());
                toWrite.append((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.sneaky." + Direction.values()[sneakyMode].toString().toUpperCase(Locale.ROOT), ChatFormatting.DARK_GREEN.getColor()));
                tooltip.add((Component)toWrite);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public NonNullList<ItemStack> getContainerItems(ItemStack itemStack) {
        NonNullList nonnulllist = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        nonnulllist.set(0, (Object)BaseCard.getInventory(itemStack).getStackInSlot(0));
        nonnulllist.set(1, (Object)BaseCard.getInventory(itemStack).getStackInSlot(1));
        return nonnulllist;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return ItemStack.EMPTY;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return !BaseCard.getInventory(stack).getStackInSlot(0).isEmpty() || !BaseCard.getInventory(stack).getStackInSlot(1).isEmpty();
    }

    public static CardItemHandler getInventory(ItemStack stack) {
        CompoundTag compound = stack.getTag();
        if (compound == null || !compound.contains("inv")) {
            return new CardItemHandler(2, stack);
        }
        CardItemHandler handler = new CardItemHandler(2, stack);
        handler.deserializeNBT(compound.getCompound("inv"));
        if (handler.getSlots() < 2) {
            handler.reSize(2);
        }
        return handler;
    }

    public static CardItemHandler setInventory(ItemStack stack, CardItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).isEmpty()) continue;
            stack.getOrCreateTag().put("inv", (Tag)handler.serializeNBT());
            return handler;
        }
        stack.removeTagKey("inv");
        return handler;
    }

    public static byte setTransferMode(ItemStack card, byte mode) {
        if (mode == 0) {
            card.removeTagKey("mode");
        } else {
            card.getOrCreateTag().putByte("mode", mode);
        }
        return mode;
    }

    public static byte getTransferMode(ItemStack card) {
        CompoundTag compound = card.getTag();
        if (compound == null || !compound.contains("mode")) {
            return 0;
        }
        return compound.getByte("mode");
    }

    public static byte nextTransferMode(ItemStack card) {
        byte mode = BaseCard.getTransferMode(card);
        return BaseCard.setTransferMode(card, (byte)(mode == 3 ? 0 : mode + 1));
    }

    public static TransferMode getNamedTransferMode(ItemStack card) {
        return TransferMode.values()[BaseCard.getTransferMode(card)];
    }

    public static byte setChannel(ItemStack card, byte channel) {
        if (channel == 0) {
            card.removeTagKey("channel");
        } else {
            card.getOrCreateTag().putByte("channel", channel);
        }
        return channel;
    }

    public static byte getChannel(ItemStack card) {
        CompoundTag compound = card.getTag();
        if (compound == null || !compound.contains("channel")) {
            return 0;
        }
        return compound.getByte("channel");
    }

    public static byte nextChannel(ItemStack card) {
        byte k = BaseCard.getChannel(card);
        return BaseCard.setChannel(card, (byte)(k == 15 ? 0 : k + 1));
    }

    public static byte previousChannel(ItemStack card) {
        byte k = BaseCard.getChannel(card);
        return BaseCard.setChannel(card, (byte)(k == 0 ? 15 : k - 1));
    }

    public static int setExtractSpeed(ItemStack card, int itemextractspeed) {
        if (itemextractspeed == 20) {
            card.removeTagKey("itemextractspeed");
        } else {
            card.getOrCreateTag().putInt("itemextractspeed", itemextractspeed);
        }
        return itemextractspeed;
    }

    public static int getExtractSpeed(ItemStack card) {
        CompoundTag compound = card.getTag();
        if (compound == null || !compound.contains("itemextractspeed")) {
            return 20;
        }
        return compound.getInt("itemextractspeed");
    }

    public static short setPriority(ItemStack card, short priority) {
        if (priority == 0) {
            card.removeTagKey("priority");
        } else {
            card.getOrCreateTag().putShort("priority", priority);
        }
        return priority;
    }

    public static short getPriority(ItemStack card) {
        CompoundTag compound = card.getTag();
        if (compound == null || !compound.contains("priority")) {
            return 0;
        }
        return compound.getShort("priority");
    }

    public static ItemStack getFilter(ItemStack card) {
        CardItemHandler cardItemHandler = BaseCard.getInventory(card);
        return cardItemHandler.getStackInSlot(0);
    }

    public static byte setSneaky(ItemStack card, byte sneaky) {
        if (sneaky == -1) {
            card.removeTagKey("sneaky");
        } else {
            card.getOrCreateTag().putByte("sneaky", sneaky);
        }
        return sneaky;
    }

    public static byte getSneaky(ItemStack card) {
        CompoundTag compound = card.getTag();
        if (compound == null || !compound.contains("sneaky")) {
            return -1;
        }
        return compound.getByte("sneaky");
    }

    public static byte nextSneaky(ItemStack card) {
        byte k = BaseCard.getSneaky(card);
        return BaseCard.setSneaky(card, (byte)(k == 5 ? -1 : k + 1));
    }

    public static byte previousSneaky(ItemStack card) {
        byte k = BaseCard.getSneaky(card);
        return BaseCard.setSneaky(card, (byte)(k == -1 ? 5 : k - 1));
    }

    public static boolean getRegulate(ItemStack stack) {
        CompoundTag compound = stack.getTag();
        if (compound == null || !compound.contains("regulate")) {
            return false;
        }
        return compound.getBoolean("regulate");
    }

    public static boolean setRegulate(ItemStack stack, boolean regulate) {
        if (!regulate) {
            stack.removeTagKey("regulate");
        } else {
            stack.getOrCreateTag().putBoolean("regulate", regulate);
        }
        return regulate;
    }

    public static int getRoundRobin(ItemStack stack) {
        CompoundTag compound = stack.getTag();
        if (compound == null || !compound.contains("roundRobin")) {
            return 0;
        }
        return compound.getInt("roundRobin");
    }

    public static int setRoundRobin(ItemStack stack, int roundRobin) {
        if (roundRobin == 0) {
            stack.removeTagKey("roundRobin");
        } else {
            stack.getOrCreateTag().putInt("roundRobin", roundRobin);
        }
        return roundRobin;
    }

    public static byte getRedstoneMode(ItemStack stack) {
        CompoundTag compound = stack.getTag();
        if (compound == null || !compound.contains("redstoneMode")) {
            return 0;
        }
        return compound.getByte("redstoneMode");
    }

    public static byte setRedstoneMode(ItemStack stack, byte redstoneMode) {
        if (redstoneMode == 0) {
            stack.removeTagKey("redstoneMode");
        } else {
            stack.getOrCreateTag().putByte("redstoneMode", redstoneMode);
        }
        return redstoneMode;
    }

    public static byte nextRedstoneMode(ItemStack card) {
        byte mode = BaseCard.getRedstoneMode(card);
        return BaseCard.setRedstoneMode(card, (byte)(mode == 2 ? 0 : mode + 1));
    }

    public static boolean getExact(ItemStack stack) {
        CompoundTag compound = stack.getTag();
        if (compound == null || !compound.contains("exact")) {
            return false;
        }
        return compound.getBoolean("exact");
    }

    public static boolean setExact(ItemStack stack, boolean exact) {
        if (!exact) {
            stack.removeTagKey("exact");
        } else {
            stack.getOrCreateTag().putBoolean("exact", exact);
        }
        return exact;
    }

    public static byte setRedstoneChannel(ItemStack card, byte redstonechannel) {
        if (redstonechannel == 0) {
            card.removeTagKey("redstonechannel");
        } else {
            card.getOrCreateTag().putByte("redstonechannel", redstonechannel);
        }
        return redstonechannel;
    }

    public static byte getRedstoneChannel(ItemStack card) {
        CompoundTag compound = card.getTag();
        if (compound == null || !compound.contains("redstonechannel")) {
            return 0;
        }
        return compound.getByte("redstonechannel");
    }

    public static byte nextRedstoneChannel(ItemStack card) {
        byte k = BaseCard.getRedstoneChannel(card);
        return BaseCard.setRedstoneChannel(card, (byte)(k == 15 ? 0 : k + 1));
    }

    public static byte previousRedstoneChannel(ItemStack card) {
        byte k = BaseCard.getRedstoneChannel(card);
        return BaseCard.setRedstoneChannel(card, (byte)(k == 0 ? 15 : k - 1));
    }

    public static boolean getAnd(ItemStack stack) {
        CompoundTag compound = stack.getTag();
        if (compound == null || !compound.contains("and")) {
            return false;
        }
        return compound.getBoolean("and");
    }

    public static boolean setAnd(ItemStack stack, boolean and) {
        if (!and) {
            stack.removeTagKey("and");
        } else {
            stack.getOrCreateTag().putBoolean("and", and);
        }
        return and;
    }

    public static enum CardType {
        ITEM,
        FLUID,
        ENERGY,
        REDSTONE,
        CHEMICAL,
        MISSING;

    }

    public static enum TransferMode {
        INSERT,
        EXTRACT,
        STOCK,
        SENSOR;

    }
}

