/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.cards;

import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CardRedstone
extends BaseCard {
    public CardRedstone() {
        this.CARDTYPE = BaseCard.CardType.REDSTONE;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardRedstoneContainer(windowId, playerInventory, player, itemstack), (Component)Component.translatable((String)"")), buf -> {
            buf.writeItem(itemstack);
            buf.writeByte(-1);
        });
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public static byte nextTransferMode(ItemStack card) {
        byte mode = CardRedstone.getTransferMode(card);
        return CardRedstone.setTransferMode(card, (byte)(mode == 1 ? 0 : mode + 1));
    }

    public static boolean getStrong(ItemStack stack) {
        CompoundTag compound = stack.getTag();
        if (compound == null || !compound.contains("redstonestrong")) {
            return false;
        }
        return compound.getBoolean("redstonestrong");
    }

    public static boolean setStrong(ItemStack stack, boolean strong) {
        if (!strong) {
            stack.removeTagKey("redstonestrong");
        } else {
            stack.getOrCreateTag().putBoolean("redstonestrong", strong);
        }
        return strong;
    }
}

