/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.filters;

import com.direwolf20.laserio.common.containers.FilterCountContainer;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.integration.mekanism.MekanismIntegration;
import com.direwolf20.laserio.integration.mekanism.MekanismStatics;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FilterCount
extends BaseFilter {
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FilterCountContainer(windowId, playerInventory, player, itemstack), (Component)Component.translatable((String)"")), buf -> {
            buf.writeItem(itemstack);
            buf.writeItem(ItemStack.EMPTY);
        });
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public static int getSlotAmount(ItemStack stack, int getSlot) {
        CompoundTag compound = stack.getOrCreateTag();
        ListTag countList = compound.getList("counts", 10);
        for (int i = 0; i < countList.size(); ++i) {
            CompoundTag countTag = countList.getCompound(i);
            int slot = countTag.getInt("Slot");
            if (slot != getSlot) continue;
            return countTag.getInt("MBAmount");
        }
        return 0;
    }

    public static void setSlotAmount(ItemStack stack, int getSlot, int setMBAmount) {
        CompoundTag compound = stack.getOrCreateTag();
        ListTag countList = compound.getList("counts", 10);
        for (int i = 0; i < countList.size(); ++i) {
            CompoundTag countTag = countList.getCompound(i);
            int slot = countTag.getInt("Slot");
            if (slot != getSlot) continue;
            countTag.putInt("MBAmount", setMBAmount);
            if (setMBAmount == 0) {
                countTag.putInt("Count", 0);
                continue;
            }
            countTag.putInt("Count", Math.max(1, (int)Math.floor(setMBAmount / 1000)));
        }
    }

    public static int getSlotCount(ItemStack stack, int getSlot) {
        CompoundTag compound = stack.getOrCreateTag();
        ListTag countList = compound.getList("counts", 10);
        for (int i = 0; i < countList.size(); ++i) {
            CompoundTag countTag = countList.getCompound(i);
            int slot = countTag.getInt("Slot");
            if (slot != getSlot) continue;
            return countTag.getInt("Count");
        }
        return 0;
    }

    public static void setSlotCount(ItemStack stack, int getSlot, int setCount) {
        CompoundTag compound = stack.getOrCreateTag();
        ListTag countList = compound.getList("counts", 10);
        for (int i = 0; i < countList.size(); ++i) {
            CompoundTag countTag = countList.getCompound(i);
            int slot = countTag.getInt("Slot");
            if (slot != getSlot) continue;
            int mbAmt = FilterCount.getSlotAmount(stack, i);
            int mbCount = (int)Math.floor(mbAmt / 1000);
            if (mbCount == setCount || mbAmt == 0) {
                countTag.putInt("Count", setCount);
                continue;
            }
            countTag.putInt("Count", setCount);
            countTag.putInt("MBAmount", setCount * 1000 + mbAmt % 1000);
        }
    }

    public static FilterCountHandler getInventory(ItemStack stack) {
        CompoundTag compound = stack.getOrCreateTag();
        FilterCountHandler handler = new FilterCountHandler(15, stack);
        handler.deserializeNBT(compound.getCompound("inv"));
        ListTag countList = compound.getList("counts", 10);
        for (int i = 0; i < countList.size(); ++i) {
            CompoundTag countTag = countList.getCompound(i);
            int slot = countTag.getInt("Slot");
            ItemStack itemStack = handler.getStackInSlot(slot);
            itemStack.setCount(countTag.getInt("Count"));
            handler.setStackInSlot(slot, itemStack);
        }
        return !compound.contains("inv") ? FilterCount.setInventory(stack, new FilterCountHandler(15, stack)) : handler;
    }

    public static FilterCountHandler setInventory(ItemStack stack, FilterCountHandler handler) {
        stack.getOrCreateTag().put("inv", (Tag)handler.serializeNBT());
        ListTag countList = new ListTag();
        for (int i = 0; i < handler.getSlots(); ++i) {
            CompoundTag countTag = new CompoundTag();
            ItemStack itemStack = handler.getStackInSlot(i);
            countTag.putInt("Slot", i);
            if (FilterCount.doesItemStackHoldFluids(itemStack) || MekanismIntegration.isLoaded() && MekanismStatics.doesItemStackHoldChemicals(itemStack)) {
                int mbAmt = FilterCount.getSlotAmount(stack, i);
                if (mbAmt > 0) {
                    countTag.putInt("Count", Math.max(1, (int)Math.floor(mbAmt / 1000)));
                    countTag.putInt("MBAmount", mbAmt);
                } else {
                    countTag.putInt("Count", itemStack.getCount());
                    countTag.putInt("MBAmount", itemStack.getCount() * 1000);
                }
            } else {
                countTag.putInt("Count", itemStack.getCount());
                countTag.putInt("MBAmount", 0);
            }
            countList.add((Object)countTag);
        }
        stack.getOrCreateTag().put("counts", (Tag)countList);
        return handler;
    }

    public static boolean doesItemStackHoldFluids(ItemStack stack) {
        Optional fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)stack);
        if (!fluidHandlerLazyOptional.isPresent()) {
            return false;
        }
        FluidStack fluidStack = FluidStack.EMPTY;
        IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.get();
        for (int tank = 0; tank < fluidHandler.getTanks() && (fluidStack = fluidHandler.getFluidInTank(tank)).isEmpty(); ++tank) {
        }
        return !fluidStack.isEmpty();
    }

    public static boolean getAllowList(ItemStack stack) {
        CompoundTag compound = stack.getOrCreateTag();
        return !compound.contains("allowList") ? FilterCount.setAllowList(stack, true) : compound.getBoolean("allowList");
    }

    public static boolean setAllowList(ItemStack stack, boolean allowList) {
        stack.getOrCreateTag().putBoolean("allowList", true);
        return true;
    }
}

