/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.filters;

import com.direwolf20.laserio.common.containers.FilterNBTContainer;
import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.util.MiscTools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FilterNBT
extends BaseFilter {
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        FilterBasicHandler handler = FilterNBT.getInventory(itemstack);
        ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FilterNBTContainer(windowId, playerInventory, player, handler, itemstack), (Component)Component.translatable((String)"")), buf -> {
            buf.writeItem(itemstack);
            buf.writeItem(ItemStack.EMPTY);
        });
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public static FilterBasicHandler getInventory(ItemStack stack) {
        CompoundTag compound = stack.getOrCreateTag();
        FilterBasicHandler handler = new FilterBasicHandler(1, stack);
        handler.deserializeNBT(compound.getCompound("inv"));
        return !compound.contains("inv") ? FilterNBT.setInventory(stack, new FilterBasicHandler(1, stack)) : handler;
    }

    public static FilterBasicHandler setInventory(ItemStack stack, FilterBasicHandler handler) {
        stack.getOrCreateTag().put("inv", (Tag)handler.serializeNBT());
        return handler;
    }

    public static void addTag(ItemStack card, String tag) {
        List<String> tags = FilterNBT.getTags(card);
        if (!tags.contains(tag)) {
            tags.add(tag);
            CompoundTag compound = card.getOrCreateTag();
            compound.put("tags", (Tag)MiscTools.stringListToNBT(tags));
        }
    }

    public static void removeTag(ItemStack card, String tag) {
        List<String> tags = FilterNBT.getTags(card);
        if (tags.contains(tag)) {
            tags.remove(tag);
            CompoundTag compound = card.getOrCreateTag();
            compound.put("tags", (Tag)MiscTools.stringListToNBT(tags));
        }
    }

    public static void clearTags(ItemStack card) {
        ArrayList<String> tags = new ArrayList<String>();
        CompoundTag compound = card.getOrCreateTag();
        compound.put("tags", (Tag)MiscTools.stringListToNBT(tags));
    }

    public static void setTags(ItemStack card, List<String> tagsIn) {
        CompoundTag compound = card.getOrCreateTag();
        compound.put("tags", (Tag)MiscTools.stringListToNBT(tagsIn));
    }

    public static void setTags(ItemStack card, CompoundTag tagsTag) {
        CompoundTag compound = card.getOrCreateTag();
        compound.put("tags", (Tag)tagsTag.getList("tags", 10));
    }

    public static List<String> getTags(ItemStack card) {
        ArrayList<String> tags = new ArrayList<String>();
        CompoundTag compound = card.getOrCreateTag();
        if (compound.contains("tags")) {
            ListTag listNBT = compound.getList("tags", 10);
            tags = new ArrayList<String>(MiscTools.NBTToStringList(listNBT));
        } else {
            compound.put("tags", (Tag)MiscTools.stringListToNBT(tags));
        }
        return tags;
    }
}

