/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.data;

import com.direwolf20.laserio.util.DimBlockPos;
import com.direwolf20.laserio.util.ParticleData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record NodeParticlesPayload(List<ParticleData> particleList) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("laserio", "node_particles_item");

    public NodeParticlesPayload(FriendlyByteBuf buffer) {
        this(NodeParticlesPayload.decodeList(buffer));
    }

    public static List<ParticleData> decodeList(FriendlyByteBuf buffer) {
        ArrayList<ParticleData> thisList = new ArrayList<ParticleData>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            int item = buffer.readInt();
            byte itemCount = buffer.readByte();
            DimBlockPos fromNode = new DimBlockPos((ResourceKey<Level>)buffer.readResourceKey(Registries.DIMENSION), buffer.readBlockPos());
            byte fromDirection = buffer.readByte();
            byte extractPosition = buffer.readByte();
            DimBlockPos toNode = new DimBlockPos((ResourceKey<Level>)buffer.readResourceKey(Registries.DIMENSION), buffer.readBlockPos());
            byte toDirection = buffer.readByte();
            byte insertPosition = buffer.readByte();
            ParticleData data = new ParticleData(item, itemCount, fromNode, fromDirection, toNode, toDirection, extractPosition, insertPosition);
            thisList.add(data);
        }
        return thisList;
    }

    public void write(FriendlyByteBuf buffer) {
        int size = this.particleList.size();
        buffer.writeInt(size);
        for (ParticleData data : this.particleList) {
            buffer.writeInt(data.item);
            buffer.writeByte(data.itemCount);
            if (data.fromData != null) {
                buffer.writeResourceKey(data.fromData.node().levelKey);
                buffer.writeBlockPos(data.fromData.node().blockPos);
                buffer.writeByte(data.fromData.direction());
                buffer.writeByte(data.fromData.position());
            }
            if (data.toData == null) continue;
            buffer.writeResourceKey(data.toData.node().levelKey);
            buffer.writeBlockPos(data.toData.node().blockPos);
            buffer.writeByte(data.toData.direction());
            buffer.writeByte(data.toData.position());
        }
    }

    public ResourceLocation id() {
        return ID;
    }
}

