/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.handler;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.network.data.NodeParticlesFluidPayload;
import com.direwolf20.laserio.util.DimBlockPos;
import com.direwolf20.laserio.util.ParticleDataFluid;
import com.direwolf20.laserio.util.ParticleRenderDataFluid;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketNodeParticlesFluid {
    public static final PacketNodeParticlesFluid INSTANCE = new PacketNodeParticlesFluid();

    public static PacketNodeParticlesFluid get() {
        return INSTANCE;
    }

    public void handle(NodeParticlesFluidPayload payload, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            List<ParticleDataFluid> tempList = payload.particleList();
            for (ParticleDataFluid data : tempList) {
                if (data.fromData != null) {
                    DimBlockPos fromPos = data.fromData.node();
                    BlockEntity fromTE = Minecraft.getInstance().level.getBlockEntity(fromPos.blockPos);
                    if (fromTE instanceof LaserNodeBE) {
                        ((LaserNodeBE)fromTE).addParticleDataFluid(new ParticleRenderDataFluid(data.fluidStack, fromPos.blockPos.relative(Direction.values()[data.fromData.direction()]), data.fromData.direction(), data.fromData.node().blockPos, data.fromData.position()));
                    }
                }
                if (data.toData == null) continue;
                DimBlockPos toPos = data.toData.node();
                BlockEntity toTE = Minecraft.getInstance().level.getBlockEntity(toPos.blockPos);
                if (!(toTE instanceof LaserNodeBE)) continue;
                ((LaserNodeBE)toTE).addParticleDataFluid(new ParticleRenderDataFluid(data.fluidStack, data.toData.node().blockPos, data.toData.direction(), toPos.blockPos.relative(Direction.values()[data.toData.direction()]), data.toData.position()));
            }
        });
    }
}

