/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.handler;

import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.FilterBasicContainer;
import com.direwolf20.laserio.common.containers.FilterCountContainer;
import com.direwolf20.laserio.common.containers.FilterNBTContainer;
import com.direwolf20.laserio.common.containers.FilterTagContainer;
import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterNBT;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.common.network.data.OpenFilterPayload;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketOpenFilter {
    public static final PacketOpenFilter INSTANCE = new PacketOpenFilter();

    public static PacketOpenFilter get() {
        return INSTANCE;
    }

    public static void doOpenFilter(final ItemStack filterItem, final ItemStack cardItem, final ServerPlayer sender, final BlockPos sourcePos) {
        Object containerProvider;
        FilterBasicHandler handler;
        if (filterItem.getItem() instanceof FilterBasic) {
            handler = FilterBasic.getInventory(filterItem);
            containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"screen.laserio.lasernode");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new FilterBasicContainer(windowId, playerInventory, (Player)sender, handler, sourcePos, filterItem, cardItem);
                }
            };
            sender.openMenu(containerProvider, buf -> {
                buf.writeItem(filterItem);
                buf.writeItem(cardItem);
            });
        }
        if (filterItem.getItem() instanceof FilterCount) {
            MenuProvider containerProvider2 = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"screen.laserio.lasernode");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new FilterCountContainer(windowId, playerInventory, (Player)sender, sourcePos, filterItem, cardItem);
                }
            };
            sender.openMenu(containerProvider2, buf -> {
                buf.writeItem(filterItem);
                buf.writeItem(cardItem);
            });
        }
        if (filterItem.getItem() instanceof FilterTag) {
            handler = FilterBasic.getInventory(filterItem);
            containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"screen.laserio.lasernode");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new FilterTagContainer(windowId, playerInventory, (Player)sender, handler, sourcePos, filterItem, cardItem);
                }
            };
            sender.openMenu(containerProvider, buf -> {
                buf.writeItem(filterItem);
                buf.writeItem(ItemStack.EMPTY);
            });
        }
        if (filterItem.getItem() instanceof FilterNBT) {
            handler = FilterBasic.getInventory(filterItem);
            containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"screen.laserio.lasernode");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new FilterNBTContainer(windowId, playerInventory, (Player)sender, handler, sourcePos, filterItem, cardItem);
                }
            };
            sender.openMenu(containerProvider, buf -> {
                buf.writeItem(filterItem);
                buf.writeItem(ItemStack.EMPTY);
            });
        }
    }

    public void handle(OpenFilterPayload payload, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Optional senderOptional = context.player();
            if (senderOptional.isEmpty()) {
                return;
            }
            ServerPlayer sender = (ServerPlayer)senderOptional.get();
            AbstractContainerMenu container = sender.containerMenu;
            if (container == null || !(container instanceof CardItemContainer)) {
                return;
            }
            Slot slot = (Slot)container.slots.get(payload.slotNumber());
            ItemStack itemStack = slot.getItem();
            PacketOpenFilter.doOpenFilter(itemStack, ((CardItemContainer)container).cardItem, sender, ((CardItemContainer)container).sourceContainer);
        });
    }
}

