/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.handler;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.blocks.LaserNode;
import com.direwolf20.laserio.common.containers.CardEnergyContainer;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.containers.customhandler.LaserNodeItemHandler;
import com.direwolf20.laserio.common.network.data.OpenNodePayload;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketOpenNode {
    public static final PacketOpenNode INSTANCE = new PacketOpenNode();

    public static PacketOpenNode get() {
        return INSTANCE;
    }

    public void handle(final OpenNodePayload payload, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            BlockPos pos;
            Optional senderOptional = context.player();
            if (senderOptional.isEmpty()) {
                return;
            }
            ServerPlayer sender = (ServerPlayer)senderOptional.get();
            AbstractContainerMenu container = sender.containerMenu;
            if (container == null) {
                return;
            }
            if (container instanceof LaserNodeContainer) {
                pos = payload.sourcePos();
            } else if (container instanceof CardItemContainer) {
                CardItemContainer cardItemContainer = (CardItemContainer)container;
                pos = cardItemContainer.sourceContainer;
            } else if (container instanceof CardEnergyContainer) {
                CardEnergyContainer cardEnergyContainer = (CardEnergyContainer)container;
                pos = cardEnergyContainer.sourceContainer;
            } else if (container instanceof CardRedstoneContainer) {
                CardRedstoneContainer cardRedstoneContainer = (CardRedstoneContainer)container;
                pos = cardRedstoneContainer.sourceContainer;
            } else {
                return;
            }
            BlockPos sourcePos = pos;
            final BlockEntity be = sender.level().getBlockEntity(sourcePos);
            if (be == null || !(be instanceof BaseLaserBE)) {
                return;
            }
            ItemStack heldStack = sender.containerMenu.getCarried();
            if (!heldStack.isEmpty()) {
                sender.containerMenu.setCarried(ItemStack.EMPTY);
            }
            final IItemHandler h = (IItemHandler)sender.level().getCapability(Capabilities.ItemHandler.BLOCK, sourcePos, (Object)Direction.values()[payload.side()]);
            final ItemStack cardHolder = LaserNode.findCardHolders((Player)sender);
            MenuProvider containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"screen.laserio.lasernode");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new LaserNodeContainer((LaserNodeBE)be, windowId, payload.side(), playerInventory, playerEntity, (LaserNodeItemHandler)h, ContainerLevelAccess.create((Level)be.getLevel(), (BlockPos)be.getBlockPos()), cardHolder);
                }
            };
            sender.openMenu(containerProvider, buf -> {
                buf.writeBlockPos(pos);
                buf.writeByte(payload.side());
                buf.writeItem(cardHolder);
            });
            if (!heldStack.isEmpty()) {
                sender.containerMenu.setCarried(heldStack);
                sender.connection.send((Packet)new ClientboundContainerSetSlotPacket(-1, -1, -1, heldStack));
            }
        });
    }
}

