/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.datagen;

import com.direwolf20.laserio.datagen.LaserIOBlockStates;
import com.direwolf20.laserio.datagen.LaserIOBlockTags;
import com.direwolf20.laserio.datagen.LaserIOItemModels;
import com.direwolf20.laserio.datagen.LaserIOItemTags;
import com.direwolf20.laserio.datagen.LaserIOLanguageProvider;
import com.direwolf20.laserio.datagen.LaserIOLootTable;
import com.direwolf20.laserio.datagen.LaserIORecipes;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod.EventBusSubscriber(modid="laserio", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LaserIORecipes(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(LaserIOLootTable::new, LootContextParamSets.BLOCK))));
        LaserIOBlockTags blockTags = new LaserIOBlockTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        LaserIOItemTags itemTags = new LaserIOItemTags(packOutput, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeClient(), (DataProvider)new LaserIOBlockStates(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new LaserIOItemModels(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new LaserIOLanguageProvider(packOutput, "en_us"));
    }
}

