/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.integration.mekanism;

import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterMod;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.integration.mekanism.MekanismStatics;
import com.direwolf20.laserio.util.BaseCardCache;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.world.item.ItemStack;

public class MekanismCardCache {
    private final BaseCardCache baseCardCache;
    private final Map<ChemicalType, List<ChemicalStack<?>>> filteredChemicals;
    private final Reference2BooleanMap<Chemical<?>> filterCacheChemical = new Reference2BooleanOpenHashMap();
    private final Reference2IntMap<Chemical<?>> filterCountsChemical = new Reference2IntOpenHashMap();

    public MekanismCardCache(BaseCardCache baseCardCache) {
        this.baseCardCache = baseCardCache;
        this.filteredChemicals = this.baseCardCache.filterCard.isEmpty() ? Map.of() : this.getFilteredChemicals();
    }

    public <STACK extends ChemicalStack<?>> List<STACK> getFilteredChemicals(IChemicalHandler<?, STACK> chemicalHandler) {
        return this.getFilteredChemicals().getOrDefault(ChemicalType.getTypeFor(chemicalHandler), List.of());
    }

    public Map<ChemicalType, List<ChemicalStack<?>>> getFilteredChemicals() {
        EnumMap filteredChemicalsMap = new EnumMap(ChemicalType.class);
        ItemStack filterCard = this.baseCardCache.filterCard;
        FilterBasicHandler filterSlotHandler = filterCard.getItem() instanceof FilterBasic ? FilterBasic.getInventory(filterCard) : FilterCount.getInventory(filterCard);
        for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
            ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            for (ChemicalType chemicalType : ChemicalType.values()) {
                IChemicalHandler handler = (IChemicalHandler)itemStack.getCapability(MekanismStatics.getItemCapabilityForChemical(chemicalType));
                if (handler == null) continue;
                ArrayList<ChemicalStack> filteredChemicals = new ArrayList<ChemicalStack>();
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    ChemicalStack chemicalStack = handler.getChemicalInTank(tank);
                    if (chemicalStack.isEmpty()) continue;
                    filteredChemicals.add(chemicalStack);
                }
                if (filteredChemicals.isEmpty()) continue;
                filteredChemicalsMap.put(chemicalType, filteredChemicals);
            }
        }
        return filteredChemicalsMap;
    }

    public boolean isStackValidForCard(ChemicalStack<?> testStack) {
        ItemStack filterCard = this.baseCardCache.filterCard;
        if (filterCard.isEmpty()) {
            return true;
        }
        return this.filterCacheChemical.computeIfAbsent((Object)testStack.getType(), key -> {
            boolean matches;
            if (filterCard.getItem() instanceof FilterTag) {
                matches = key.getTags().map(tagKey -> tagKey.location().toString().toLowerCase(Locale.ROOT)).anyMatch(this.baseCardCache.filterTags::contains);
            } else {
                Predicate<ChemicalStack> validityPredicate = filterCard.getItem() instanceof FilterMod ? stack -> stack.getTypeRegistryName().getNamespace().equals(key.getRegistryName().getNamespace()) : stack -> key == stack.getType();
                matches = this.filteredChemicals.getOrDefault(ChemicalType.getTypeFor((Chemical)key), List.of()).stream().anyMatch(validityPredicate);
            }
            return matches == this.baseCardCache.isAllowList;
        });
    }

    public int getFilterAmt(ChemicalStack<?> testStack) {
        ItemStack filterCard = this.baseCardCache.filterCard;
        if (filterCard.isEmpty()) {
            return 0;
        }
        if (!(filterCard.getItem() instanceof FilterCount)) {
            return -1;
        }
        return this.filterCountsChemical.computeIfAbsent((Object)testStack.getType(), key -> {
            ChemicalType keyType = ChemicalType.getTypeFor((Chemical)key);
            FilterCountHandler filterSlotHandler = FilterCount.getInventory(filterCard);
            for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
                ChemicalStack<?> chemicalStack;
                ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
                if (itemStack.isEmpty() || (chemicalStack = MekanismStatics.getFirstChemicalOnItemStack(itemStack, keyType)).isEmpty() || key != chemicalStack.getType()) continue;
                return FilterCount.getSlotAmount(filterCard, i);
            }
            return 0;
        });
    }
}

