/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.integration.mekanism.client.chemicalparticle;

import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ChemicalFlowParticleData;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ChemicalFlowParticle
extends BreakingItemParticle {
    public static ParticleProvider<ChemicalFlowParticleData> FACTORY = (data, world, x, y, z, xSpeed, ySpeed, zSpeed) -> new ChemicalFlowParticle(world, x, y, z, data.target, data.getChemicalStack(), data.ticksPerBlock);

    public ChemicalFlowParticle(ClientLevel world, double x, double y, double z, Vec3 target, ChemicalStack<?> chemicalStack, int ticksPerBlock) {
        super(world, x, y, z, ItemStack.EMPTY);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        Vec3 source = new Vec3(this.x, this.y, this.z);
        Vec3 path = target.subtract(source).normalize().multiply(1.0, 1.0, 1.0);
        this.gravity = 0.0f;
        double distance = target.distanceTo(source);
        this.hasPhysics = false;
        float minSize = 0.15f;
        float maxSize = 0.25f;
        float partSize = minSize + world.random.nextFloat() * (maxSize - minSize);
        float speedModifier = 0.5f * (partSize - minSize) / (maxSize - minSize) + 0.25f;
        float speedAdjust = (float)ticksPerBlock * (1.0f / speedModifier);
        this.xd += path.x / (double)speedAdjust;
        this.yd += path.y / (double)speedAdjust;
        this.zd += path.z / (double)speedAdjust;
        this.lifetime = (int)(distance * (double)speedAdjust);
        this.scale(partSize);
        this.setSprite((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(chemicalStack.getType().getIcon()));
        int i = chemicalStack.getChemicalColorRepresentation();
        this.rCol *= (float)(i >> 16 & 0xFF) / 255.0f;
        this.gCol *= (float)(i >> 8 & 0xFF) / 255.0f;
        this.bCol *= (float)(i & 0xFF) / 255.0f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
        }
    }
}

