/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.integration.mekanism.client.chemicalparticle;

import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.MekanismModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Locale;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class ChemicalFlowParticleData
implements ParticleOptions {
    private final BoxedChemicalStack chemicalStack;
    public final Vec3 target;
    public final int ticksPerBlock;
    public static final ParticleOptions.Deserializer<ChemicalFlowParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ChemicalFlowParticleData>(){
        private static final DynamicCommandExceptionType INVALID_TYPE = new DynamicCommandExceptionType(type -> Component.translatable((String)"laserio.error.particle.chemical_type", (Object[])new Object[]{type}));
        private static final Dynamic2CommandExceptionType INVALID_CHEMICAL = new Dynamic2CommandExceptionType((name, type) -> Component.translatable((String)"laserio.error.particle.chemical", (Object[])new Object[]{name, type}));

        @Nonnull
        public ChemicalFlowParticleData fromCommand(ParticleType<ChemicalFlowParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double tx = reader.readDouble();
            reader.expect(' ');
            double ty = reader.readDouble();
            reader.expect(' ');
            double tz = reader.readDouble();
            reader.expect(' ');
            int ticks = reader.readInt();
            reader.expect(' ');
            String rawType = reader.readString();
            ChemicalType type = ChemicalType.fromString((String)rawType);
            if (type == null) {
                throw INVALID_TYPE.create((Object)rawType);
            }
            reader.expect(' ');
            String rawRegistryName = reader.readString();
            ResourceLocation registryName = ResourceLocation.tryParse((String)rawRegistryName);
            if (registryName == null) {
                throw INVALID_CHEMICAL.create((Object)rawRegistryName, (Object)type);
            }
            reader.expect(' ');
            long amount = reader.readLong();
            Registry registry = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case ChemicalType.GAS -> MekanismAPI.GAS_REGISTRY;
                case ChemicalType.INFUSION -> MekanismAPI.INFUSE_TYPE_REGISTRY;
                case ChemicalType.PIGMENT -> MekanismAPI.PIGMENT_REGISTRY;
                case ChemicalType.SLURRY -> MekanismAPI.SLURRY_REGISTRY;
            };
            BoxedChemicalStack boxedStack = registry.getOptional(registryName).map(chemical -> BoxedChemicalStack.box((ChemicalStack)chemical.getStack(amount))).orElseThrow(() -> INVALID_CHEMICAL.create((Object)registryName, (Object)type));
            return new ChemicalFlowParticleData(boxedStack, tx, ty, tz, ticks);
        }

        public ChemicalFlowParticleData fromNetwork(ParticleType<ChemicalFlowParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new ChemicalFlowParticleData(BoxedChemicalStack.read((FriendlyByteBuf)buffer), buffer.readVec3(), buffer.readInt());
        }
    };

    public ChemicalFlowParticleData(BoxedChemicalStack chemicalStack, double tx, double ty, double tz, int ticks) {
        this(chemicalStack, new Vec3(tx, ty, tz), ticks);
    }

    public ChemicalFlowParticleData(BoxedChemicalStack chemicalStack, Vec3 target, int ticks) {
        this.chemicalStack = chemicalStack.copy();
        this.target = target;
        this.ticksPerBlock = ticks;
    }

    @Nonnull
    public ParticleType<ChemicalFlowParticleData> getType() {
        return MekanismModParticles.CHEMICALFLOWPARTICLE.get();
    }

    public void writeToNetwork(FriendlyByteBuf buffer) {
        this.chemicalStack.write(buffer);
        buffer.writeVec3(this.target);
        buffer.writeInt(this.ticksPerBlock);
    }

    @Nonnull
    public String writeToString() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %d %s %s %d", this.getType(), this.target.x, this.target.y, this.target.z, this.ticksPerBlock, this.chemicalStack.getChemicalType().getSerializedName(), this.chemicalStack.getChemicalStack().getType().getRegistryName(), this.chemicalStack.getChemicalStack().getAmount());
    }

    public ChemicalStack<?> getChemicalStack() {
        return this.chemicalStack.getChemicalStack();
    }
}

