/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.cards.CardFluid;
import com.direwolf20.laserio.common.items.cards.CardItem;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterMod;
import com.direwolf20.laserio.common.items.filters.FilterNBT;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.integration.mekanism.CardChemical;
import com.direwolf20.laserio.integration.mekanism.MekanismCardCache;
import com.direwolf20.laserio.util.FluidStackKey;
import com.direwolf20.laserio.util.ItemStackKey;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BaseCardCache {
    public final Direction direction;
    public final ItemStack cardItem;
    public final byte channel;
    public final byte redstoneMode;
    public final byte redstoneChannel;
    public final ItemStack filterCard;
    public final int cardSlot;
    public final List<ItemStack> filteredItems;
    public final List<FluidStack> filteredFluids;
    public final List<String> filterTags;
    public final List<String> filterNBTs;
    public final byte sneaky;
    public final LaserNodeBE be;
    public final BaseCard.CardType cardType;
    public int extractLimit = 0;
    public int insertLimit = 0;
    public boolean enabled = true;
    public final boolean isAllowList;
    public final boolean isCompareNBT;
    public final Map<ItemStackKey, Boolean> filterCache = new Object2BooleanOpenHashMap();
    public final Map<ItemStackKey, Integer> filterCounts = new Object2IntOpenHashMap();
    public final Map<FluidStackKey, Boolean> filterCacheFluid = new Object2BooleanOpenHashMap();
    public final Map<FluidStackKey, Integer> filterCountsFluid = new Object2IntOpenHashMap();
    public MekanismCardCache mekanismCardCache;

    public BaseCardCache(Direction direction, ItemStack cardItem, int cardSlot, LaserNodeBE be) {
        this.cardItem = cardItem;
        this.direction = direction;
        this.sneaky = BaseCard.getSneaky(cardItem);
        this.channel = BaseCard.getChannel(cardItem);
        this.redstoneMode = BaseCard.getRedstoneMode(cardItem);
        this.redstoneChannel = BaseCard.getRedstoneChannel(cardItem);
        this.filterCard = BaseCard.getFilter(cardItem);
        this.cardSlot = cardSlot;
        if (cardItem.getItem() instanceof CardItem) {
            this.cardType = BaseCard.CardType.ITEM;
        } else if (cardItem.getItem() instanceof CardFluid) {
            this.cardType = BaseCard.CardType.FLUID;
        } else if (cardItem.getItem() instanceof CardEnergy) {
            this.cardType = BaseCard.CardType.ENERGY;
            this.insertLimit = CardEnergy.getInsertLimitPercent(cardItem);
            this.extractLimit = CardEnergy.getExtractLimitPercent(cardItem);
        } else if (cardItem.getItem() instanceof CardRedstone) {
            this.cardType = BaseCard.CardType.REDSTONE;
        } else if (cardItem.getItem() instanceof CardChemical) {
            this.cardType = BaseCard.CardType.CHEMICAL;
            this.mekanismCardCache = new MekanismCardCache(this);
        } else {
            this.cardType = BaseCard.CardType.MISSING;
        }
        this.be = be;
        if (this.filterCard.isEmpty()) {
            this.filteredItems = new ArrayList<ItemStack>();
            this.filteredFluids = new ArrayList<FluidStack>();
            this.filterTags = new ArrayList<String>();
            this.filterNBTs = new ArrayList<String>();
            this.isAllowList = false;
            this.isCompareNBT = false;
        } else {
            this.filteredItems = this.getFilteredItems();
            this.filteredFluids = this.getFilteredFluids();
            this.filterTags = this.getFilterTags();
            this.filterNBTs = this.getFilterNBTs();
            this.isAllowList = BaseFilter.getAllowList(this.filterCard);
            this.isCompareNBT = BaseFilter.getCompareNBT(this.filterCard);
        }
        this.setEnabled();
    }

    public void setEnabled() {
        byte strength;
        this.enabled = this.redstoneMode == 0 || BaseCard.getNamedTransferMode(this.cardItem).equals((Object)BaseCard.TransferMode.SENSOR) ? true : ((strength = this.be.getRedstoneChannelStrength(this.redstoneChannel)) > 0 && this.redstoneMode == 1 ? false : strength != 0 || this.redstoneMode != 2);
    }

    public int getFilterAmt(ItemStack testStack) {
        if (this.filterCard.isEmpty()) {
            return 0;
        }
        if (!(this.filterCard.getItem() instanceof FilterCount)) {
            return -1;
        }
        ItemStackKey key = new ItemStackKey(testStack, this.isCompareNBT);
        if (this.filterCounts.containsKey(key)) {
            return this.filterCounts.get(key);
        }
        for (ItemStack stack : this.filteredItems) {
            if (!key.equals(new ItemStackKey(stack, this.isCompareNBT))) continue;
            this.filterCounts.put(key, stack.getCount());
            return stack.getCount();
        }
        this.filterCounts.put(key, 0);
        return 0;
    }

    public int getFilterAmt(FluidStack testStack) {
        if (this.filterCard.isEmpty()) {
            return 0;
        }
        if (!(this.filterCard.getItem() instanceof FilterCount)) {
            return -1;
        }
        FluidStackKey key = new FluidStackKey(testStack, this.isCompareNBT);
        if (this.filterCountsFluid.containsKey(key)) {
            return this.filterCountsFluid.get(key);
        }
        FilterCountHandler filterSlotHandler = FilterCount.getInventory(this.filterCard);
        for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
            Optional fluidHandlerLazyOptional;
            ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
            if (itemStack.isEmpty() || (fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)itemStack)).isEmpty()) continue;
            IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.get();
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluidStack = fluidHandler.getFluidInTank(tank);
                if (!key.equals(new FluidStackKey(fluidStack, this.isCompareNBT))) continue;
                int mbAmt = FilterCount.getSlotAmount(this.filterCard, i);
                this.filterCountsFluid.put(key, mbAmt);
                return mbAmt;
            }
        }
        this.filterCountsFluid.put(key, 0);
        return 0;
    }

    public List<ItemStack> getFilteredItems() {
        ArrayList<ItemStack> filteredItems = new ArrayList<ItemStack>();
        FilterBasicHandler filterSlotHandler = this.filterCard.getItem() instanceof FilterBasic ? FilterBasic.getInventory(this.filterCard) : FilterCount.getInventory(this.filterCard);
        for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
            ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            filteredItems.add(itemStack);
        }
        return filteredItems;
    }

    public List<FluidStack> getFilteredFluids() {
        ArrayList<FluidStack> filteredFluids = new ArrayList<FluidStack>();
        FilterBasicHandler filterSlotHandler = this.filterCard.getItem() instanceof FilterBasic ? FilterBasic.getInventory(this.filterCard) : FilterCount.getInventory(this.filterCard);
        for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
            Optional fluidHandlerLazyOptional;
            ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
            if (itemStack.isEmpty() || (fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)itemStack)).isEmpty()) continue;
            IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.get();
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluidStack = fluidHandler.getFluidInTank(tank);
                if (fluidStack.isEmpty()) continue;
                filteredFluids.add(fluidStack);
            }
        }
        return filteredFluids;
    }

    public List<String> getFilterTags() {
        List<String> filterTags = new ArrayList<String>();
        if (this.filterCard.getItem() instanceof FilterTag) {
            filterTags = FilterTag.getTags(this.filterCard);
        }
        return filterTags;
    }

    public List<String> getFilterNBTs() {
        List<String> filterNBTs = new ArrayList<String>();
        if (this.filterCard.getItem() instanceof FilterNBT) {
            filterNBTs = FilterTag.getTags(this.filterCard);
        }
        return filterNBTs;
    }

    public boolean isStackValidForCard(ItemStack testStack) {
        if (this.filterCard.isEmpty()) {
            return true;
        }
        ItemStackKey key = new ItemStackKey(testStack, this.isCompareNBT);
        if (this.filterCache.containsKey(key)) {
            return this.filterCache.get(key);
        }
        if (this.filterCard.getItem() instanceof FilterMod) {
            for (ItemStack stack : this.filteredItems) {
                if (!stack.getItem().getCreatorModId(stack).equals(testStack.getItem().getCreatorModId(testStack))) continue;
                this.filterCache.put(key, this.isAllowList);
                return this.isAllowList;
            }
        } else if (this.filterCard.getItem() instanceof FilterTag) {
            for (TagKey tagKey : testStack.getItem().builtInRegistryHolder().tags().toList()) {
                String tag = tagKey.location().toString().toLowerCase(Locale.ROOT);
                if (!this.filterTags.contains(tag)) continue;
                this.filterCache.put(key, this.isAllowList);
                return this.isAllowList;
            }
        } else if (this.filterCard.getItem() instanceof FilterNBT) {
            for (String tag : testStack.getOrCreateTag().getAllKeys()) {
                if (!this.filterNBTs.contains(tag)) continue;
                this.filterCache.put(key, this.isAllowList);
                return this.isAllowList;
            }
        } else {
            for (ItemStack stack : this.filteredItems) {
                if (!key.equals(new ItemStackKey(stack, this.isCompareNBT))) continue;
                this.filterCache.put(key, this.isAllowList);
                return this.isAllowList;
            }
        }
        this.filterCache.put(key, !this.isAllowList);
        return !this.isAllowList;
    }

    public boolean isStackValidForCard(FluidStack testStack) {
        if (this.filterCard.isEmpty()) {
            return true;
        }
        FluidStackKey key = new FluidStackKey(testStack, this.isCompareNBT);
        if (this.filterCacheFluid.containsKey(key)) {
            return this.filterCacheFluid.get(key);
        }
        if (this.filterCard.getItem() instanceof FilterMod) {
            for (FluidStack stack : this.filteredFluids) {
                if (!BuiltInRegistries.FLUID.getKey((Object)stack.getFluid()).getNamespace().equals(BuiltInRegistries.FLUID.getKey((Object)testStack.getFluid()).getNamespace())) continue;
                this.filterCacheFluid.put(key, this.isAllowList);
                return this.isAllowList;
            }
        } else if (this.filterCard.getItem() instanceof FilterTag) {
            for (TagKey tagKey : testStack.getFluid().builtInRegistryHolder().tags().toList()) {
                String tag = tagKey.location().toString().toLowerCase(Locale.ROOT);
                if (!this.filterTags.contains(tag)) continue;
                this.filterCacheFluid.put(key, this.isAllowList);
                return this.isAllowList;
            }
        } else {
            for (FluidStack stack : this.filteredFluids) {
                if (!key.equals(new FluidStackKey(stack, this.isCompareNBT))) continue;
                this.filterCacheFluid.put(key, this.isAllowList);
                return this.isAllowList;
            }
        }
        this.filterCacheFluid.put(key, !this.isAllowList);
        return !this.isAllowList;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseCardCache) {
            return ((Object)((Object)((BaseCardCache)obj).be)).equals((Object)this.be) && ((BaseCardCache)obj).direction.equals((Object)this.direction) && ((BaseCardCache)obj).cardSlot == this.cardSlot;
        }
        return false;
    }
}

