/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.cards.CardFluid;
import com.direwolf20.laserio.common.items.cards.CardItem;
import com.direwolf20.laserio.integration.mekanism.CardChemical;
import com.direwolf20.laserio.util.BaseCardCache;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;

public class ExtractorCardCache
extends BaseCardCache {
    public final int extractAmt;
    public final int tickSpeed;
    public int remainingSleep;
    public boolean exact;
    public int roundRobin;

    public ExtractorCardCache(Direction direction, ItemStack cardItem, int cardSlot, LaserNodeBE be) {
        super(direction, cardItem, cardSlot, be);
        this.extractAmt = this.cardType.equals((Object)BaseCard.CardType.ITEM) ? (int)CardItem.getItemExtractAmt(cardItem) : (this.cardType.equals((Object)BaseCard.CardType.FLUID) ? CardFluid.getFluidExtractAmt(cardItem) : (this.cardType.equals((Object)BaseCard.CardType.ENERGY) ? CardEnergy.getEnergyExtractAmt(cardItem) : (this.cardType.equals((Object)BaseCard.CardType.CHEMICAL) ? CardChemical.getChemicalExtractAmt(cardItem) : 0)));
        this.tickSpeed = cardItem.getItem() instanceof CardEnergy ? CardEnergy.getExtractSpeed(cardItem) : BaseCard.getExtractSpeed(cardItem);
        this.exact = BaseCard.getExact(cardItem);
        this.roundRobin = BaseCard.getRoundRobin(cardItem);
    }

    public int getRemainingSleep() {
        return this.remainingSleep;
    }

    public void setRemainingSleep(int sleep) {
        this.remainingSleep = sleep;
    }

    public int decrementSleep() {
        --this.remainingSleep;
        if (this.remainingSleep <= 0) {
            this.remainingSleep = 0;
            return 0;
        }
        return this.remainingSleep;
    }
}

