/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidStackKey {
    public final Fluid fluid;
    public final CompoundTag nbt;
    private final int hash;

    public FluidStackKey(FluidStack stack, boolean compareNBT) {
        this.fluid = stack.getFluid();
        this.nbt = compareNBT ? stack.getTag() : new CompoundTag();
        this.hash = Objects.hash(this.fluid, this.nbt);
    }

    public FluidStack getStack() {
        return new FluidStack(this.fluid, 1, this.nbt);
    }

    public FluidStack getStack(int amt) {
        return new FluidStack(this.fluid, amt, this.nbt);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FluidStackKey) {
            return ((FluidStackKey)obj).fluid == this.fluid && Objects.equals(((FluidStackKey)obj).nbt, this.nbt);
        }
        return false;
    }
}

