/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.util.BaseCardCache;
import com.direwolf20.laserio.util.ExtractorCardCache;
import com.direwolf20.laserio.util.InserterCardCache;
import com.direwolf20.laserio.util.ItemStackKey;
import com.direwolf20.laserio.util.TransferResult;
import com.google.common.collect.ArrayListMultimap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemHandlerUtil {
    @Nonnull
    public static ExtractResult extractItem(IItemHandler source, @Nonnull ItemStack incstack, boolean simulate, boolean isCompareNBT) {
        return ItemHandlerUtil.extractItem(source, incstack, incstack.getCount(), simulate, isCompareNBT);
    }

    @Nonnull
    public static ExtractResult extractItemOnce(IItemHandler source, @Nonnull ItemStack incstack, int amount, boolean simulate, boolean isCompareNBT) {
        if (source == null || incstack.isEmpty()) {
            return new ExtractResult(incstack, -1);
        }
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        ItemStack tempStack = ItemStack.EMPTY;
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stackInSlot = source.getStackInSlot(i);
            if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT))) continue;
            int extractAmt = Math.min(amount, stackInSlot.getCount());
            tempStack = source.extractItem(i, extractAmt, simulate);
            return new ExtractResult(tempStack, i);
        }
        return new ExtractResult(tempStack, -1);
    }

    @Nonnull
    public static ExtractResult extractItem(IItemHandler source, @Nonnull ItemStack incstack, int amount, boolean simulate, boolean isCompareNBT) {
        if (source == null || incstack.isEmpty()) {
            return new ExtractResult(incstack, -1);
        }
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        ItemStack tempStack = ItemStack.EMPTY;
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stackInSlot = source.getStackInSlot(i);
            if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT))) continue;
            int extractAmt = Math.min(amount, stackInSlot.getCount());
            if (tempStack.isEmpty()) {
                tempStack = source.extractItem(i, extractAmt, simulate);
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)tempStack, (ItemStack)stackInSlot)) {
                tempStack.grow(source.extractItem(i, extractAmt, simulate).getCount());
            } else {
                return new ExtractResult(tempStack, i);
            }
            if (tempStack.isEmpty() || (amount -= extractAmt) != 0) continue;
            return new ExtractResult(tempStack, i);
        }
        return new ExtractResult(tempStack, -1);
    }

    @Nonnull
    public static ExtractResult extractItemBackwards(IItemHandler source, @Nonnull ItemStack incstack, int amount, boolean simulate, boolean isCompareNBT) {
        if (source == null || incstack.isEmpty()) {
            return new ExtractResult(incstack, -1);
        }
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        ItemStack tempStack = ItemStack.EMPTY;
        for (int i = source.getSlots() - 1; i >= 0; --i) {
            ItemStack stackInSlot = source.getStackInSlot(i);
            if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT))) continue;
            int extractAmt = Math.min(amount, stackInSlot.getCount());
            if (tempStack.isEmpty()) {
                tempStack = source.extractItem(i, extractAmt, simulate);
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)tempStack, (ItemStack)stackInSlot)) {
                tempStack.grow(source.extractItem(i, extractAmt, simulate).getCount());
            } else {
                return new ExtractResult(tempStack, i);
            }
            if (tempStack.isEmpty() || (amount -= extractAmt) != 0) continue;
            return new ExtractResult(tempStack, i);
        }
        return new ExtractResult(tempStack, -1);
    }

    @Nonnull
    public static TransferResult extractItemWithSlots(LaserNodeBE be, IItemHandler source, @Nonnull ItemStack incstack, int amount, boolean simulate, boolean isCompareNBT, BaseCardCache cardCache) {
        TransferResult extractResults = new TransferResult();
        if (source == null || incstack.isEmpty()) {
            return extractResults;
        }
        int amtRemaining = amount;
        ItemStack remainingStack = incstack.copy();
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        for (int i = 0; i < source.getSlots(); ++i) {
            int extractAmt;
            ItemStack extractStack;
            ItemStack stackInSlot = source.getStackInSlot(i);
            if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT)) || (extractStack = source.extractItem(i, extractAmt = Math.min(amtRemaining, stackInSlot.getCount()), simulate)).isEmpty()) continue;
            extractResults.addResult(new TransferResult.Result(source, i, cardCache, extractStack, be, true));
            remainingStack.setCount(amtRemaining -= extractAmt);
            if (amtRemaining != 0) continue;
            return extractResults;
        }
        extractResults.addRemainingStack(remainingStack);
        return extractResults;
    }

    @Nonnull
    public static TransferResult extractItemWithSlotsBackwards(LaserNodeBE be, IItemHandler source, @Nonnull ItemStack incstack, int amount, boolean simulate, boolean isCompareNBT, ExtractorCardCache extractorCardCache) {
        TransferResult extractResults = new TransferResult();
        if (source == null || incstack.isEmpty()) {
            return extractResults;
        }
        int amtRemaining = amount;
        ItemStack remainingStack = incstack.copy();
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        for (int i = source.getSlots() - 1; i >= 0; --i) {
            ItemStack stackInSlot = source.getStackInSlot(i);
            if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT))) continue;
            int extractAmt = Math.min(amtRemaining, stackInSlot.getCount());
            ItemStack extractStack = source.extractItem(i, extractAmt, simulate);
            extractResults.addResult(new TransferResult.Result(source, i, extractorCardCache, extractStack, be, true));
            remainingStack.setCount(amtRemaining -= extractAmt);
            if (amtRemaining != 0) continue;
            return extractResults;
        }
        extractResults.addRemainingStack(remainingStack);
        return extractResults;
    }

    @Nonnull
    public static TransferResult insertItemWithSlots(LaserNodeBE be, IItemHandler source, @Nonnull ItemStack incstack, int startAt, boolean simulate, boolean isCompareNBT, boolean stacksFirst, InserterCardCache inserterCardCache) {
        return ItemHandlerUtil.insertItemWithSlots(be, source, incstack, incstack.getCount(), startAt, simulate, isCompareNBT, stacksFirst, inserterCardCache);
    }

    @Nonnull
    public static TransferResult insertItemWithSlots(LaserNodeBE be, IItemHandler source, @Nonnull ItemStack incstack, int amount, int startAt, boolean simulate, boolean isCompareNBT, boolean stacksFirst, InserterCardCache inserterCardCache) {
        TransferResult insertResults = new TransferResult();
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        if (source == null || incstack.isEmpty()) {
            return insertResults;
        }
        int amtRemaining = amount;
        ItemStack remainingStack = incstack.copy();
        remainingStack.setCount(amtRemaining);
        if (inserterCardCache.filterCard.getItem() instanceof FilterCount) {
            int filterCount = inserterCardCache.getFilterAmt(incstack);
            if (filterCount <= 0) {
                return insertResults;
            }
            InventoryCounts inventoryCounts = new InventoryCounts(source, inserterCardCache.isCompareNBT);
            int amtInInv = inventoryCounts.getCount(remainingStack);
            int amtNeeded = filterCount - amtInInv;
            if (amtNeeded <= 0) {
                return insertResults;
            }
            amtRemaining = Math.min(remainingStack.getCount(), amtNeeded);
            remainingStack.setCount(amtRemaining);
        }
        ItemStackKey key = new ItemStackKey(incstack, isCompareNBT);
        if (stacksFirst) {
            for (int i = startAt; i < source.getSlots(); ++i) {
                int amtInserted;
                ItemStack stackInSlot = source.getStackInSlot(i);
                if (stackInSlot.isEmpty()) {
                    emptySlots.add(i);
                }
                if (!key.equals(new ItemStackKey(stackInSlot, isCompareNBT)) || (amtInserted = amtRemaining - (remainingStack = source.insertItem(i, remainingStack, simulate)).getCount()) <= 0) continue;
                insertResults.addResult(new TransferResult.Result(source, i, inserterCardCache, incstack.split(amtInserted), be, false));
                amtRemaining = remainingStack.getCount();
                if (amtRemaining != 0) continue;
                return insertResults;
            }
            for (Integer i : emptySlots) {
                remainingStack = source.insertItem(i.intValue(), remainingStack, simulate);
                if (remainingStack.getCount() == amtRemaining) continue;
                insertResults.addResult(new TransferResult.Result(source, i, inserterCardCache, incstack.split(amtRemaining - remainingStack.getCount()), be, false));
                amtRemaining = remainingStack.getCount();
                if (amtRemaining != 0) continue;
                return insertResults;
            }
        } else {
            for (int i = 0; i < source.getSlots(); ++i) {
                remainingStack = source.insertItem(i, remainingStack, simulate);
                insertResults.addResult(new TransferResult.Result(source, i, inserterCardCache, incstack.split(amtRemaining - remainingStack.getCount()), be, false));
                amtRemaining = remainingStack.getCount();
                if (amtRemaining != 0) continue;
                return insertResults;
            }
        }
        insertResults.addRemainingStack(remainingStack);
        return insertResults;
    }

    public static boolean doItemsMatch(ItemStack a, ItemStack b, boolean isCompareNBT) {
        return isCompareNBT ? ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b) : ItemStack.isSameItem((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemsStackable(ItemStack toInsert, ItemStack inSlot) {
        if (toInsert.isEmpty() || inSlot.isEmpty()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)toInsert);
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    public record ExtractResult(ItemStack itemStack, int slot) {
    }

    public static class InventoryCounts {
        private final ArrayListMultimap<Item, ItemStack> itemMap = ArrayListMultimap.create();
        private int totalCount = 0;
        private boolean isCompareNBT;

        public InventoryCounts() {
        }

        public InventoryCounts(IItemHandler handler, boolean compareNBT) {
            this.isCompareNBT = compareNBT;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                this.setCount(stack);
            }
        }

        public InventoryCounts(ListTag nbtList) {
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag nbt = nbtList.getCompound(i);
                ItemStack stack = ItemStack.of((CompoundTag)nbt);
                stack.setCount(nbt.getInt("count"));
                this.setCount(stack);
            }
        }

        public ListTag serialize() {
            ListTag nbtList = new ListTag();
            int i = 0;
            for (ItemStack stack : this.itemMap.values()) {
                CompoundTag nbt = new CompoundTag();
                nbt.putInt("count", stack.getCount());
                stack.save(nbt);
                nbtList.add(i, (Tag)nbt);
                ++i;
            }
            return nbtList;
        }

        public void addHandler(IItemHandler handler) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                this.setCount(stack);
            }
        }

        public void addHandlerWithFilter(IItemHandler handler, BaseCardCache filterCard) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty() || !filterCard.isStackValidForCard(stack)) continue;
                this.setCount(stack);
            }
        }

        public ArrayListMultimap<Item, ItemStack> getItemCounts() {
            return this.itemMap;
        }

        public void setCount(ItemStack stack) {
            if (stack.isEmpty()) {
                return;
            }
            for (ItemStack cacheStack : this.itemMap.get((Object)stack.getItem())) {
                boolean sameItems = this.isCompareNBT ? ItemHandlerHelper.canItemStacksStack((ItemStack)cacheStack, (ItemStack)stack) : ItemStack.isSameItem((ItemStack)cacheStack, (ItemStack)stack);
                if (!sameItems) continue;
                cacheStack.grow(stack.getCount());
                this.totalCount += stack.getCount();
                return;
            }
            this.itemMap.put((Object)stack.getItem(), (Object)stack.copy());
            this.totalCount += stack.getCount();
        }

        public ItemStack removeStack(ItemStack stack, int count) {
            ItemStack returnStack = ItemStack.EMPTY;
            for (ItemStack cacheStack : this.itemMap.get((Object)stack.getItem())) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)cacheStack, (ItemStack)stack)) continue;
                returnStack = cacheStack.split(count);
                break;
            }
            if (returnStack.isEmpty()) {
                return returnStack;
            }
            this.itemMap.get((Object)returnStack.getItem()).removeIf(o -> o.isEmpty());
            this.totalCount -= returnStack.getCount();
            return returnStack;
        }

        public int getCount(ItemStack stack) {
            for (ItemStack cacheStack : this.itemMap.get((Object)stack.getItem())) {
                boolean sameItems = this.isCompareNBT ? ItemHandlerHelper.canItemStacksStack((ItemStack)cacheStack, (ItemStack)stack) : ItemStack.isSameItem((ItemStack)cacheStack, (ItemStack)stack);
                if (!sameItems) continue;
                return cacheStack.getCount();
            }
            return 0;
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }

    public static class InventoryInfo {
        private final NonNullList<ItemStack> inventory;
        private final IntList stackSizes = new IntArrayList();

        public InventoryInfo(IItemHandler handler) {
            this.inventory = NonNullList.withSize((int)handler.getSlots(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                this.inventory.set(i, (Object)stack);
                this.stackSizes.add(stack.getCount());
            }
        }
    }
}

