/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.handler;

import com.google.common.collect.Sets;
import fuzs.magnumtorch.MagnumTorch;
import fuzs.magnumtorch.config.ServerConfig;
import fuzs.magnumtorch.world.level.block.MagnumTorchType;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobSpawningHandler {
    private static final Set<Entity> PASSENGERS_TO_REMOVE = Sets.newLinkedHashSet();

    public static EventResult onEntitySpawn(Entity entity, ServerLevel level, @Nullable MobSpawnType spawnType) {
        if (spawnType == null || !MagnumTorch.CONFIG.getHolder(ServerConfig.class).isAvailable()) {
            return EventResult.PASS;
        }
        for (MagnumTorchType type : MagnumTorchType.values()) {
            if (!MobSpawningHandler.isSpawnCancelled(level.getPoiManager(), entity.getType(), entity.blockPosition(), spawnType, type.getPoiTypeKey(), type.getConfig())) continue;
            entity.getRootVehicle().getSelfAndPassengers().distinct().filter(passenger -> passenger != entity).forEach(PASSENGERS_TO_REMOVE::add);
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static void onEndServerTick(MinecraftServer server) {
        Iterator<Entity> iterator = PASSENGERS_TO_REMOVE.iterator();
        while (iterator.hasNext()) {
            iterator.next().discard();
            iterator.remove();
        }
    }

    private static boolean isSpawnCancelled(PoiManager poiManager, EntityType<?> entityType, BlockPos toCheck, @NotNull MobSpawnType spawnType, ResourceKey<PoiType> poiTypeKey, ServerConfig.MagnumTorchConfig config) {
        if (config.blockedSpawnTypes.contains(spawnType) && config.isAffected(entityType)) {
            return poiManager.findAll(poiType -> poiType.is(poiTypeKey), $ -> true, toCheck, (int)Math.ceil((double)Math.max(config.horizontalRange, config.verticalRange) * 1.7320508076), PoiManager.Occupancy.ANY).anyMatch(pos -> config.shapeType.isPositionContained((BlockPos)pos, toCheck, config.horizontalRange, config.verticalRange));
        }
        return false;
    }
}

