/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.block;

import dev.architectury.event.EventResult;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ky.someone.mods.gag.GAG;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.block.BlockRegistry;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.world.GAGPointOfInterestStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NoSolicitorsSign
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty SILENT = BooleanProperty.create((String)"silent");
    private static final Map<Direction, VoxelShape> AABBS = new EnumMap<Direction, VoxelShape>(Map.of(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)7.0, (double)5.0, (double)12.0, (double)9.0, (double)9.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)4.0, (double)13.0, (double)12.0, (double)14.0, (double)15.0), Block.box((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0)}), Direction.SOUTH, Shapes.or((VoxelShape)Block.box((double)7.0, (double)5.0, (double)2.0, (double)9.0, (double)9.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)14.0, (double)3.0), Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)2.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0)}), Direction.EAST, Shapes.or((VoxelShape)Block.box((double)2.0, (double)5.0, (double)7.0, (double)4.0, (double)9.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)4.0, (double)4.0, (double)3.0, (double)14.0, (double)12.0), Block.box((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0)}), Direction.WEST, Shapes.or((VoxelShape)Block.box((double)12.0, (double)5.0, (double)7.0, (double)14.0, (double)9.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)13.0, (double)4.0, (double)4.0, (double)15.0, (double)14.0, (double)12.0), Block.box((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), Block.box((double)14.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)14.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0)})));

    public NoSolicitorsSign() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).noCollission().strength(4.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SILENT, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SILENT, FACING, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return AABBS.get(state.getValue((Property)FACING));
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        GAGUtil.appendInfoTooltip(tooltip, List.of(Component.translatable((String)"block.gag.no_solicitors.info.1").withStyle(GAGUtil.TOOLTIP_MAIN), Component.translatable((String)"block.gag.no_solicitors.info.2").withStyle(GAGUtil.TOOLTIP_EXTRA)));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())).isSolid();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = this.defaultBlockState();
        FluidState fluid = ctx.getLevel().getFluidState(ctx.getClickedPos());
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        for (Direction direction : ctx.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(state = (BlockState)state.setValue((Property)FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)level, pos)) continue;
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        if (direction.getOpposite() == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, newState, level, pos, newPos);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getItemInHand(hand).is(ItemTags.WOOL)) {
            state = (BlockState)state.cycle((Property)SILENT);
            level.setBlockAndUpdate(pos, state);
            level.playSound(null, pos, SoundEvents.POWDER_SNOW_PLACE, SoundSource.BLOCKS, 0.2f, 0.7f);
            player.displayClientMessage((Component)Component.translatable((String)"block.gag.no_solicitors.silent", (Object[])new Object[]{GAGUtil.styledBool((Boolean)state.getValue((Property)SILENT))}), true);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bl) {
        if (!state.is(newState.getBlock()) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GAGPointOfInterestStorage.get(serverLevel).removeIfPresent(pos);
        }
        super.onRemove(state, level, pos, newState, bl);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GAGPointOfInterestStorage.get(serverLevel).add(pos, this);
        }
        super.setPlacedBy(level, pos, state, entity, stack);
    }

    public static EventResult notBuyingYourStuff(Entity entity, Level level) {
        ServerLevel serverLevel;
        EntityType type = entity.getType();
        if ((type == EntityType.WANDERING_TRADER || type == EntityType.TRADER_LLAMA) && level instanceof ServerLevel && NoSolicitorsSign.blockWandererSpawn(serverLevel = (ServerLevel)level, entity.getOnPos())) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static boolean blockWandererSpawn(ServerLevel serverLevel, BlockPos pos) {
        Optional<BlockPos> ward = GAGPointOfInterestStorage.get(serverLevel).checkNearbyPOIs((Block)BlockRegistry.NO_SOLICITORS_SIGN.get(), pos, (Integer)GAGConfig.Miscellaneous.NO_SOLICITORS_RADIUS.get());
        GAG.LOGGER.debug("Wanderer spawn check at {} returned {}", (Object)pos, (Object)ward.isPresent());
        if (ward.isPresent()) {
            BlockPos wardPos = ward.get();
            if (!serverLevel.isLoaded(wardPos)) {
                return false;
            }
            BlockState state = serverLevel.getBlockState(wardPos);
            if (state.getBlock() != BlockRegistry.NO_SOLICITORS_SIGN.get()) {
                GAG.LOGGER.warn("No Solicitors Sign at {} does not exist, has it been removed?", (Object)wardPos);
                GAGPointOfInterestStorage.get(serverLevel).removeIfPresent(wardPos);
                return false;
            }
            Boolean silent = (Boolean)state.getValue((Property)SILENT);
            if (!((Boolean)state.getValue((Property)SILENT)).booleanValue()) {
                serverLevel.playSound(null, pos, SoundEvents.WANDERING_TRADER_DEATH, SoundSource.BLOCKS, 0.2f, 0.7f);
                double d = serverLevel.random.nextGaussian() * 0.25;
                double e = serverLevel.random.nextGaussian() * 0.5;
                double f = serverLevel.random.nextGaussian() * 0.25;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + d, (double)pos.getY() + e, (double)pos.getZ() + f, 5, d, e, f, 0.01);
            }
            return true;
        }
        return false;
    }
}

