/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.client;

import com.google.common.collect.Iterables;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.block.BlockRegistry;
import ky.someone.mods.gag.client.render.TimeAcceleratorEntityRenderer;
import ky.someone.mods.gag.client.screen.LabelingMenuScreen;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.entity.EntityTypeRegistry;
import ky.someone.mods.gag.entity.TimeAcceleratorEntity;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.menu.MenuTypeRegistry;
import ky.someone.mods.gag.particle.ParticleTypeRegistry;
import ky.someone.mods.gag.particle.client.MagicParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@OnlyIn(value=Dist.CLIENT)
public interface GAGClient {
    public static void init(IEventBus bus) {
        GAGClient.registerEntityRenderers();
        ClientLifecycleEvent.CLIENT_SETUP.register(GAGClient::setup);
        ClientGuiEvent.RENDER_HUD.register(GAGClient::renderHUD);
        bus.addListener(GAGClient::registerParticles);
    }

    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleTypeRegistry.MAGIC.get(), MagicParticle.Provider::new);
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(EntityTypeRegistry.TIME_ACCELERATOR, TimeAcceleratorEntityRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.MINING_DYNAMITE, ThrownItemRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.FISHING_DYNAMITE, ThrownItemRenderer::new);
    }

    public static void renderHUD(GuiGraphics graphics, float partialTicks) {
        Item item;
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        ClientLevel level = mc.level;
        LocalPlayer player = mc.player;
        if (level == null || player == null) {
            return;
        }
        HitResult hitResult = mc.hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            BlockPos pos = blockHit.getBlockPos();
            Block block = level.getBlockState(pos).getBlock();
            TimeAcceleratorEntity accelerator = (TimeAcceleratorEntity)((Object)Iterables.getFirst((Iterable)level.getEntitiesOfClass(TimeAcceleratorEntity.class, new AABB(pos)), null));
            if (accelerator != null) {
                int accelSpeed = accelerator.getTimesAccelerated();
                double timeLeft = (double)accelerator.getTicksRemaining() / 20.0;
                if (accelSpeed == 0) {
                    return;
                }
                GAGClient.renderHudTooltip(mc, graphics, List.of(block.getName(), Component.translatable((String)"info.gag.time_sand_tooltip_mult", (Object[])new Object[]{GAGUtil.asStyledValue(accelSpeed, ((Integer)GAGConfig.SandsOfTime.MAX_RATE.get()).intValue(), Integer.toString(1 << accelSpeed))}), Component.translatable((String)"info.gag.time_sand_tooltip_time", (Object[])new Object[]{GAGUtil.asStyledValue(timeLeft, ((Integer)GAGConfig.SandsOfTime.DURATION_PER_USE.get()).intValue(), String.format("%.2f", timeLeft))})));
                return;
            }
        }
        ItemStack stack = player.getUseItem();
        List<Object> tooltip = List.of();
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof GAGItem) {
            GAGItem item2 = (GAGItem)item;
            tooltip = item2.getUsingTooltip((Player)player, stack, player.getTicksUsingItem());
        } else {
            stack = player.getMainHandItem();
            item = stack.getItem();
            if (item instanceof GAGItem) {
                GAGItem item3 = (GAGItem)item;
                tooltip = item3.getHoldingTooltip((Player)player, stack);
            } else {
                stack = player.getOffhandItem();
                item = stack.getItem();
                if (item instanceof GAGItem) {
                    GAGItem item4 = (GAGItem)item;
                    tooltip = item4.getHoldingTooltip((Player)player, stack);
                }
            }
        }
        if (!tooltip.isEmpty()) {
            GAGClient.renderHudTooltip(mc, graphics, tooltip);
        }
    }

    private static void renderHudTooltip(Minecraft mc, GuiGraphics graphics, List<Component> text) {
        if (mc.screen != null) {
            return;
        }
        int x = mc.getWindow().getGuiScaledWidth() / 2;
        int y = mc.getWindow().getGuiScaledHeight() / 2;
        graphics.renderComponentTooltip(mc.font, text, x + 10, y);
    }

    public static void setup(Minecraft minecraft) {
        RenderTypeRegistry.register((RenderType)RenderType.cutoutMipped(), (Block[])new Block[]{(Block)BlockRegistry.NO_SOLICITORS_SIGN.get()});
        MenuRegistry.registerScreenFactory(MenuTypeRegistry.LABELING.get(), LabelingMenuScreen::new);
        ColorHandlerRegistry.registerItemColors((stack, index) -> index == 0 ? PigmentJarItem.getRgbColor(stack) : -1, (ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.PIGMENT_JAR.get()});
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ItemRegistry.PIGMENT_JAR.get()), (ResourceLocation)GAGUtil.id("pigment_amount"), (stack, level, entity, seed) -> (float)PigmentJarItem.getColorAmount(stack) / 64.0f);
    }
}

