/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.entity;

import java.util.ArrayList;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.entity.AbstractDynamiteEntity;
import ky.someone.mods.gag.entity.EntityTypeRegistry;
import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.network.FishsplosionPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class FishingDynamiteEntity
extends AbstractDynamiteEntity {
    public static final TagKey<EntityType<?>> FISH_TAG = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)GAGUtil.id("fishing_dynamite_fish"));

    public FishingDynamiteEntity(EntityType<? extends FishingDynamiteEntity> type, Level level) {
        super(type, level);
    }

    public FishingDynamiteEntity(double x, double y, double z, Level level) {
        super(EntityTypeRegistry.FISHING_DYNAMITE.get(), x, y, z, level);
    }

    public FishingDynamiteEntity(LivingEntity owner, Level level) {
        super(EntityTypeRegistry.FISHING_DYNAMITE.get(), owner, level);
    }

    public void tick() {
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        this.level().addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, this.getX(-vec3.x) + this.random.nextDouble() * 0.6 - 0.3, this.getY(-vec3.y) + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ(-vec3.z) + this.random.nextDouble() * 0.6 - 0.3, vec3.x, vec3.y, vec3.z);
        if (this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(1.2));
        }
    }

    @Override
    public void detonate(Vec3 pos) {
        Fishsplosion explosion;
        Integer r = (Integer)GAGConfig.Dynamite.FISHING_RADIUS.get();
        Level level = this.level();
        if (!EventHooks.onExplosionStart((Level)level, (Explosion)(explosion = new Fishsplosion(level, (Entity)this, pos.x, pos.y, pos.z, r.intValue())))) {
            explosion.explode();
            explosion.finalizeExplosion(false);
            for (Player player : level.players()) {
                if (!(player.distanceToSqr((Entity)this) < 4096.0)) continue;
                new FishsplosionPacket(explosion).sendTo((ServerPlayer)player);
            }
        }
    }

    protected Item getDefaultItem() {
        return (Item)ItemRegistry.FISHING_DYNAMITE.get();
    }

    public static class Fishsplosion
    extends Explosion {
        private int fishHit = 0;
        public final Vec3 pos = new Vec3(this.x, this.y, this.z);
        public final float radius = this.radius();
        private final boolean isInWater;

        public Fishsplosion(Level level, @Nullable Entity entity, double x, double y, double z, float radius) {
            super(level, entity, x, y, z, radius, false, Explosion.BlockInteraction.KEEP);
            double eps = 0.028;
            this.isInWater = BlockPos.betweenClosedStream((AABB)AABB.ofSize((Vec3)this.pos, (double)eps, (double)eps, (double)eps)).anyMatch(pos -> level.getFluidState(pos).is(FluidTags.WATER));
        }

        public void explode() {
            if (!this.isInWater) {
                return;
            }
            AABB hitbox = AABB.unitCubeFromLowerCorner((Vec3)this.pos).inflate((double)this.radius);
            for (LivingEntity entity : this.level.getEntitiesOfClass(LivingEntity.class, hitbox)) {
                double distSqr = entity.distanceToSqr(this.pos);
                if (distSqr > (double)(this.radius * this.radius) || !entity.isInWater() || entity.ignoreExplosion((Explosion)this)) continue;
                GAGConfig.Dynamite.TargetFilter filter = (GAGConfig.Dynamite.TargetFilter)((Object)GAGConfig.Dynamite.FISHING_TARGET_FILTER.get());
                if (((Boolean)GAGConfig.Dynamite.FISHING_INSTAKILL_FISH.get()).booleanValue() && filter.isFish((Entity)entity)) {
                    ++this.fishHit;
                    entity.hurt(this.damageSource, Float.MAX_VALUE);
                    continue;
                }
                double relDist = Math.sqrt(distSqr) / (double)this.radius;
                double seen = Fishsplosion.getSeenPercent((Vec3)this.pos, (Entity)entity);
                double damageFactor = (1.0 - relDist) * seen;
                float damage = (float)((double)((int)(damageFactor * damageFactor + damageFactor)) / 2.0 * 7.0 * (double)this.radius + 1.0);
                if (filter.isFish((Entity)entity)) {
                    ++this.fishHit;
                    entity.hurt(this.damageSource, damage * 2.0f);
                    continue;
                }
                if (!((Boolean)GAGConfig.Dynamite.FISHING_DAMAGE_ALL.get()).booleanValue()) continue;
                entity.hurt(this.damageSource, damage / 2.0f);
            }
        }

        public void finalizeExplosion(boolean isClient) {
            if (isClient) {
                RandomSource random = this.level.random;
                if (this.isInWater) {
                    int particleCount = (int)(this.radius * 4.0f);
                    ArrayList<Vec3> points = new ArrayList<Vec3>();
                    for (int i = 0; i < particleCount; ++i) {
                        double angle = random.nextDouble() * Math.PI * 2.0;
                        double dist = random.nextDouble() * (double)this.radius;
                        double x = this.pos.x + Math.cos(angle) * dist;
                        double z = this.pos.z + Math.sin(angle) * dist;
                        points.add(new Vec3(x, 0.0, z));
                    }
                    BlockPos cur = BlockPos.containing((Position)this.pos).above();
                    while (this.level.isInWorldBounds(cur) && !this.level.getFluidState(cur).isEmpty()) {
                        for (Vec3 p : points) {
                            this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, p.x, (double)cur.getY() + 0.5, p.z, 0.0, 0.1, 0.0);
                        }
                        cur = cur.above();
                    }
                    for (int i = 0; i < particleCount * 4; ++i) {
                        double angle = random.nextDouble() * Math.PI * 2.0;
                        double dist = random.nextDouble() * (double)this.radius;
                        double x = this.pos.x + Math.cos(angle) * dist;
                        double y = (double)cur.getY() + 0.5;
                        double z = this.pos.z + Math.sin(angle) * dist;
                        this.level.addParticle((ParticleOptions)ParticleTypes.FISHING, x, y, z, 0.0, 0.05, 0.0);
                        this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, x, y, z, 0.0, 0.2, 0.0);
                        this.level.addParticle((ParticleOptions)ParticleTypes.SPLASH, x, y, z, 0.0, 0.1, 0.0);
                    }
                    this.level.playLocalSound(cur, SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 0.3f, 1.5f, false);
                } else {
                    for (int i = 0; i < 20; ++i) {
                        this.level.addParticle((ParticleOptions)ParticleTypes.FISHING, this.pos.x + random.nextGaussian(), this.pos.y + (double)random.nextFloat(), this.pos.z + random.nextGaussian(), 0.0, 0.05, 0.0);
                    }
                    this.level.playLocalSound(this.pos.x, this.pos.y, this.pos.z, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 0.6f, (1.0f + (random.nextFloat() - random.nextFloat()) * 0.2f) * 0.7f, false);
                }
            }
            if (this.isInWater) {
                this.level.playSound(null, this.pos.x, this.pos.y, this.pos.z, SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 0.6f, 1.0f);
                if (!isClient) {
                    Integer add = (Integer)GAGConfig.Dynamite.ADDITIONAL_FISHING_LOOT.get();
                    int fishDropped = this.fishHit;
                    ArrayList itemsToDrop = new ArrayList();
                    LootParams lootParams = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)this.pos).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.KILLER_ENTITY, (Object)this.getIndirectSourceEntity()).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)this.getDirectSourceEntity()).create(LootContextParamSets.FISHING);
                    LootTable lootTable = this.level.getServer().getLootData().getLootTable(BuiltInLootTables.FISHING_FISH);
                    for (int i = 0; i < add && !((double)fishDropped > 1.5 * (double)add.intValue()); ++i) {
                        double chance = 1.0 / (1.0 + Math.exp((double)fishDropped - 0.75 * (double)add.intValue()));
                        if (!(this.level.random.nextDouble() < chance)) continue;
                        lootTable.getRandomItems(lootParams, itemsToDrop::add);
                        ++fishDropped;
                    }
                    for (ItemStack itemStack : itemsToDrop) {
                        this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.x, this.y, this.z, itemStack));
                    }
                }
            }
        }
    }
}

