/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.entity;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.entity.AbstractDynamiteEntity;
import ky.someone.mods.gag.entity.EntityTypeRegistry;
import ky.someone.mods.gag.item.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class MiningDynamiteEntity
extends AbstractDynamiteEntity {
    public static final TagKey<Block> MINING_DYNAMITE_EFFECTIVE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)GAGUtil.id("mining_dynamite_effective"));

    public MiningDynamiteEntity(EntityType<? extends MiningDynamiteEntity> type, Level level) {
        super(type, level);
    }

    public MiningDynamiteEntity(double x, double y, double z, Level level) {
        super(EntityTypeRegistry.MINING_DYNAMITE.get(), x, y, z, level);
    }

    public MiningDynamiteEntity(LivingEntity owner, Level level) {
        super(EntityTypeRegistry.MINING_DYNAMITE.get(), owner, level);
    }

    public void tick() {
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(-vec3.x) + this.random.nextDouble() * 0.6 - 0.3, this.getY(-vec3.y) + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ(-vec3.z) + this.random.nextDouble() * 0.6 - 0.3, vec3.x, vec3.y, vec3.z);
    }

    protected void onHitEntity(EntityHitResult hitEntity) {
        Entity entity;
        super.onHitEntity(hitEntity);
        if (((Boolean)GAGConfig.Dynamite.MINING_GIVES_HASTE.get()).booleanValue() && (entity = hitEntity.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 160, 1, false, false));
            entity2.addEffect(new MobEffectInstance(MobEffects.GLOWING, 60, 1, false, false));
        }
    }

    @Override
    public void detonate(Vec3 pos) {
        BlockMiningExplosion explosion;
        Integer r = (Integer)GAGConfig.Dynamite.MINING_RADIUS.get();
        Level level = this.level();
        if (!EventHooks.onExplosionStart((Level)level, (Explosion)(explosion = new BlockMiningExplosion(level, (Entity)this, pos.x, pos.y, pos.z, r.intValue())))) {
            explosion.explode();
            explosion.finalizeExplosion(false);
            for (Player player : level.players()) {
                if (!(player.distanceToSqr((Entity)this) < 4096.0)) continue;
                ((ServerPlayer)player).connection.send((Packet)new ClientboundExplodePacket(pos.x, pos.y, pos.z, (float)r.intValue(), explosion.getToBlow(), null, explosion.getBlockInteraction(), explosion.getSmallExplosionParticles(), explosion.getLargeExplosionParticles(), explosion.getExplosionSound()));
            }
        }
    }

    protected Item getDefaultItem() {
        return (Item)ItemRegistry.MINING_DYNAMITE.get();
    }

    private static class BlockMiningExplosion
    extends Explosion {
        public BlockMiningExplosion(Level level, @Nullable Entity entity, double x, double y, double z, float radius) {
            super(level, entity, null, new ExplosionDamageCalculator(){

                public Optional<Float> getBlockExplosionResistance(Explosion explosion, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
                    if (!fluidState.isEmpty()) {
                        return Optional.empty();
                    }
                    Optional orig = super.getBlockExplosionResistance(explosion, blockGetter, blockPos, blockState, fluidState);
                    return orig.map(f -> {
                        if (blockState.is(MINING_DYNAMITE_EFFECTIVE)) {
                            return Float.valueOf(f.floatValue() * 0.75f);
                        }
                        return f;
                    });
                }

                public boolean shouldBlockExplode(Explosion explosion, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, float f) {
                    return blockState.getFluidState().isEmpty() && super.shouldBlockExplode(explosion, blockGetter, blockPos, blockState, f);
                }
            }, x, y, z, radius, false, Explosion.BlockInteraction.DESTROY, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
        }

        public void explode() {
            this.level.gameEvent(this.getDirectSourceEntity(), GameEvent.EXPLODE, BlockPos.containing((double)this.x, (double)this.y, (double)this.z));
            HashSet set = Sets.newHashSet();
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    block2: for (int l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d = (float)j / 15.0f * 2.0f - 1.0f;
                        double e = (float)k / 15.0f * 2.0f - 1.0f;
                        double f = (float)l / 15.0f * 2.0f - 1.0f;
                        double g = Math.sqrt(d * d + e * e + f * f);
                        d /= g;
                        e /= g;
                        f /= g;
                        double m = this.x;
                        double n = this.y;
                        double o = this.z;
                        float p = 0.3f;
                        for (float h = this.radius() * (0.7f + this.level.random.nextFloat() * 0.6f); h > 0.0f; h -= 0.22500001f) {
                            BlockPos blockPos = BlockPos.containing((double)m, (double)n, (double)o);
                            BlockState blockState = this.level.getBlockState(blockPos);
                            FluidState fluidState = this.level.getFluidState(blockPos);
                            if (!this.level.isInWorldBounds(blockPos)) continue block2;
                            Optional optional = this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, blockPos, blockState, fluidState);
                            if (optional.isPresent()) {
                                h -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (h > 0.0f && this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, blockPos, blockState, h)) {
                                set.add(blockPos);
                            }
                            m += d * (double)0.3f;
                            n += e * (double)0.3f;
                            o += f * (double)0.3f;
                        }
                    }
                }
            }
            this.getToBlow().addAll(set);
        }
    }
}

