/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.entity;

import dev.architectury.networking.NetworkManager;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.particle.ParticleTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;

public class TimeAcceleratorEntity
extends Entity {
    public static final String TIMES_ACCELERATED = "timesAccelerated";
    public static final String TICKS_REMAINING = "ticksRemaining";
    private static final EntityDataAccessor<Integer> timesAccelerated = SynchedEntityData.defineId(TimeAcceleratorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ticksRemaining = SynchedEntityData.defineId(TimeAcceleratorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public TimeAcceleratorEntity(EntityType<? extends TimeAcceleratorEntity> type, Level level) {
        super(type, level);
        this.entityData.set(timesAccelerated, (Object)0);
        this.entityData.set(ticksRemaining, (Object)0);
    }

    protected void defineSynchedData() {
        this.entityData.define(timesAccelerated, (Object)0);
        this.entityData.define(ticksRemaining, (Object)0);
    }

    public void tick() {
        super.tick();
        BlockPos pos = this.blockPosition();
        Level level = this.level();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        BlockState state = level.getBlockState(pos);
        BlockEntity be = level.getBlockEntity(pos);
        for (int i = 0; i < this.getSpeedMultiplier() - 1; ++i) {
            if (be != null) {
                BlockEntityTicker ticker = be.getBlockState().getTicker(level, be.getType());
                if (ticker == null) continue;
                ticker.tick(level, pos, state, be);
                continue;
            }
            if (state.isRandomlyTicking()) {
                int randomChance;
                if (level.isClientSide() || (randomChance = (Integer)GAGConfig.SandsOfTime.RANDOM_TICK_CHANCE.get() / level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING)) != 0 && level.random.nextInt(randomChance) != 0) continue;
                state.randomTick((ServerLevel)level, pos, level.random);
                continue;
            }
            this.remove(Entity.RemovalReason.KILLED);
            break;
        }
        double particleChance = (double)this.getTimesAccelerated() / (double)((Integer)GAGConfig.SandsOfTime.MAX_RATE.get()).intValue() * (double)this.getTicksRemaining() / (double)((Integer)GAGConfig.SandsOfTime.DURATION_PER_USE.get() * 20);
        if (this.random.nextDouble() < particleChance) {
            SimpleParticleType magic = ParticleTypeRegistry.MAGIC.get();
            level.addParticle((ParticleOptions)magic, (double)x, (double)y + 0.05 + (double)this.random.nextFloat(), (double)((float)z + this.random.nextFloat()), 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)magic, (double)x + 1.0, (double)y + 0.05 + (double)this.random.nextFloat(), (double)((float)z + this.random.nextFloat()), 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)magic, (double)((float)x + this.random.nextFloat()), (double)y + 0.05 + (double)this.random.nextFloat(), (double)z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)magic, (double)((float)x + this.random.nextFloat()), (double)y + 0.05 + (double)this.random.nextFloat(), (double)z + 1.0, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)magic, (double)((float)x + this.random.nextFloat()), (double)y + 1.1, (double)((float)z + this.random.nextFloat()), 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)magic, (double)((float)x + this.random.nextFloat()), (double)y - 0.05, (double)((float)z + this.random.nextFloat()), 0.0, 0.0, 0.0);
        }
        if (this.getTicksRemaining() <= 0 && !level.isClientSide) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        this.setTicksRemaining(this.getTicksRemaining() - 1);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(timesAccelerated, (Object)compound.getInt(TIMES_ACCELERATED));
        this.entityData.set(ticksRemaining, (Object)compound.getInt(TICKS_REMAINING));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt(TIMES_ACCELERATED, this.getTimesAccelerated());
        compound.putInt(TICKS_REMAINING, this.getTicksRemaining());
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public int getSpeedMultiplier() {
        return 1 << this.getTimesAccelerated();
    }

    public int getTimesAccelerated() {
        return (Integer)this.entityData.get(timesAccelerated);
    }

    public void setTimesAccelerated(int rate) {
        this.entityData.set(timesAccelerated, (Object)rate);
    }

    public int getTicksRemaining() {
        return (Integer)this.entityData.get(ticksRemaining);
    }

    public void setTicksRemaining(int ticks) {
        this.entityData.set(ticksRemaining, (Object)ticks);
    }
}

