/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.List;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.entity.AbstractDynamiteEntity;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.sound.GAGSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DynamiteItem<T extends AbstractDynamiteEntity>
extends GAGItem {
    private final EntityFactory factory;
    @Nullable
    private final List<Component> infoTooltip;
    private final double throwSpeed;

    public DynamiteItem(Item.Properties properties, EntityFactory factory, @Nullable List<Component> infoTooltip, double throwSpeed) {
        super(properties);
        this.factory = factory;
        this.infoTooltip = infoTooltip;
        this.throwSpeed = throwSpeed;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), GAGSounds.DYNAMITE_THROW.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            AbstractDynamiteEntity dynamite = this.factory.create(player, level);
            dynamite.setItem(itemStack);
            dynamite.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            dynamite.setDeltaMovement(dynamite.getDeltaMovement().scale(this.throwSpeed));
            level.addFreshEntity((Entity)dynamite);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (this.infoTooltip != null) {
            GAGUtil.appendInfoTooltip(tooltip, this.infoTooltip);
        }
    }

    @FunctionalInterface
    public static interface EntityFactory {
        public AbstractDynamiteEntity create(Player var1, Level var2);
    }
}

