/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.item.HearthstoneItem;
import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.misc.TeleportPos;
import ky.someone.mods.gag.sound.GAGSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnergizedHearthstoneItem
extends HearthstoneItem {
    private static final String TARGET_KEY = "target";

    public EnergizedHearthstoneItem() {
        super(GAGConfig.Hearthstone.ENERGIZED_DURABILITY);
    }

    public boolean isBound(ItemStack stack) {
        return stack.getTagElement(TARGET_KEY) != null;
    }

    @Override
    public TeleportPos getTeleportPos(@Nullable Player player, ItemStack stack) {
        if (this.isBound(stack)) {
            return TeleportPos.fromNbt(stack.getTagElement(TARGET_KEY));
        }
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(this.getTargetText(null, stack));
        GAGUtil.appendInfoTooltip(tooltip, List.of(this.getTranslation("info_adv", new Object[0]).withStyle(GAGUtil.TOOLTIP_MAIN), this.getTranslation("info_adv_2", new Object[0]).withStyle(GAGUtil.TOOLTIP_MAIN), this.getTranslation("info_adv_3", new Object[0]).withStyle(GAGUtil.TOOLTIP_MAIN), Component.translatable((String)"info.gag.supports_unbreaking").withStyle(GAGUtil.TOOLTIP_EXTRA)));
    }

    @Override
    public Component getTargetText(@Nullable Player player, ItemStack stack) {
        TeleportPos target = this.getTeleportPos(player, stack);
        if (target != null) {
            Vec3 pos = target.pos();
            ResourceLocation level = target.level();
            MutableComponent text = Component.translatable((String)String.format("(%.1f %.1f %.1f)", pos.x, pos.y, pos.z)).withStyle(GAGUtil.COLOUR_TRUE);
            if (player == null || !level.equals((Object)player.level().dimension().location())) {
                text.append(" @ ").append((Component)Component.translatable((String)level.toString()).withStyle(ChatFormatting.GRAY));
            }
            return this.getTranslation("target.bound", text).withStyle(GAGUtil.COLOUR_INFO);
        }
        return this.getTranslation("target.unbound", new Object[0]).withStyle(GAGUtil.COLOUR_FALSE);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!this.isBound(stack)) {
            if (player.isShiftKeyDown()) {
                TeleportPos pos = new TeleportPos(player.level().dimension().location(), player.position(), player.getYRot());
                stack.addTagElement(TARGET_KEY, (Tag)pos.toNbt());
                player.playSound(GAGSounds.HEARTHSTONE_THUNDER.get(), 0.5f, 1.25f);
                return InteractionResultHolder.success((Object)stack);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        return super.use(level, player, hand);
    }

    @Override
    public int getUseDuration(ItemStack stack) {
        return this.isBound(stack) ? super.getUseDuration(stack) : 0;
    }

    public static void lightningStrike(LightningBolt bolt, Level level, Vec3 pos, List<Entity> toStrike) {
        Iterator<Entity> iter = toStrike.iterator();
        while (iter.hasNext()) {
            Entity entity = iter.next();
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack stack = itemEntity.getItem();
            if (stack.is((Item)ItemRegistry.HEARTHSTONE.get())) {
                ItemStack newStack = new ItemStack((ItemLike)ItemRegistry.ENERGIZED_HEARTHSTONE.get());
                float damage = (float)stack.getDamageValue() / (float)stack.getMaxDamage();
                newStack.setDamageValue((int)((float)newStack.getMaxDamage() * damage));
                EnchantmentHelper.setEnchantments((Map)EnchantmentHelper.getEnchantments((ItemStack)stack), (ItemStack)newStack);
                itemEntity.setItem(newStack);
                bolt.hitEntities.add(entity);
                iter.remove();
                continue;
            }
            if (!stack.is((Item)ItemRegistry.ENERGIZED_HEARTHSTONE.get())) continue;
            if (!bolt.hitEntities.contains(entity)) {
                stack.removeTagKey(TARGET_KEY);
                float damage = (float)stack.getDamageValue() / (float)stack.getMaxDamage();
                stack.setDamageValue((int)((double)stack.getMaxDamage() * Math.max(0.0, (double)damage - 0.25)));
            }
            itemEntity.setInvulnerable(true);
            bolt.hitEntities.add(entity);
            iter.remove();
        }
    }
}

