/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import java.util.List;
import java.util.Optional;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.misc.TeleportPos;
import ky.someone.mods.gag.sound.GAGSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HearthstoneItem
extends GAGItem {
    private final IntValue durability;

    public HearthstoneItem() {
        this(GAGConfig.Hearthstone.DURABILITY);
    }

    public HearthstoneItem(IntValue durability) {
        super(new Item.Properties().stacksTo(1));
        this.durability = durability;
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int ticks) {
        Vec3 pos = entity.position();
        double radius = 0.75;
        double spirals = 4.0;
        int i = 1;
        while ((double)i <= spirals) {
            double x = Math.cos(((double)ticks + Math.PI * 2 * (double)i) / spirals) * radius;
            double z = Math.sin(((double)ticks + Math.PI * 2 * (double)i) / spirals) * radius;
            level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, pos.x + x, pos.y + 0.1 * (20.0 - (double)ticks % 20.0), pos.z + z, 0.0, 0.0, 0.0);
            ++i;
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.success((Object)stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)this.durability.get();
    }

    public int getUseDuration(ItemStack stack) {
        return (Integer)GAGConfig.Hearthstone.WARMUP.get();
    }

    @Nullable
    public TeleportPos getTeleportPos(@Nullable Player player, ItemStack stack) {
        boolean allowSpawn = (Boolean)GAGConfig.Hearthstone.ALLOW_SPAWN.get();
        boolean ignoreSpawnBlock = (Boolean)GAGConfig.Hearthstone.IGNORE_SPAWN_BLOCK.get();
        boolean useAnchorCharge = (Boolean)GAGConfig.Hearthstone.USE_ANCHOR_CHARGE.get();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer;
            MinecraftServer server = serverPlayer.server;
            serverPlayer = (ServerPlayer)player;
            ServerLevel respawnDim = server.getLevel(serverPlayer.getRespawnDimension());
            if (respawnDim != null) {
                Optional actualPos;
                BlockPos respawnPos = serverPlayer.getRespawnPosition();
                if (respawnPos != null && (actualPos = Player.findRespawnPositionAndUseSpawnBlock((ServerLevel)respawnDim, (BlockPos)respawnPos, (float)serverPlayer.getRespawnAngle(), (boolean)ignoreSpawnBlock, (boolean)useAnchorCharge)).isPresent()) {
                    return new TeleportPos(respawnDim.dimension().location(), (Vec3)actualPos.get(), serverPlayer.getRespawnAngle());
                }
            } else {
                respawnDim = server.overworld();
            }
            if (allowSpawn) {
                Vec3 spawnPos = Vec3.atBottomCenterOf((Vec3i)respawnDim.getSharedSpawnPos());
                return new TeleportPos(respawnDim.dimension().location(), spawnPos, serverPlayer.getRespawnAngle());
            }
        }
        return null;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide && entity instanceof ServerPlayer) {
            ServerLevel targetLevel;
            ServerPlayer player = (ServerPlayer)entity;
            TeleportPos target = this.getTeleportPos((Player)player, stack);
            if (target != null && (targetLevel = target.getLevel(player.server)) != null) {
                return this.tryTeleport(stack, targetLevel, player, target.pos(), target.yaw());
            }
            player.sendSystemMessage((Component)this.getTranslation("no_target", new Object[0]).withStyle(ChatFormatting.RED));
            level.playSound(null, player.blockPosition(), GAGSounds.TELEPORT_FAIL.get(), SoundSource.PLAYERS, 0.6f, 1.0f);
        }
        return stack;
    }

    private ItemStack tryTeleport(ItemStack stack, ServerLevel level, ServerPlayer player, Vec3 pos, float yaw) {
        boolean creative = player.isCreative();
        int durabilityUsed = level.equals(player.serverLevel()) ? 1 : (Integer)GAGConfig.Hearthstone.DIMENSION_MULTIPLIER.get();
        double distance = player.position().distanceTo(pos) * (double)durabilityUsed;
        Integer range = (Integer)GAGConfig.Hearthstone.RANGE.get();
        if (durabilityUsed > 0) {
            if (range < 0 || distance < (double)range.intValue()) {
                stack.hurtAndBreak(durabilityUsed, (LivingEntity)player, p -> p.broadcastBreakEvent(p.getUsedItemHand()));
                player.teleportTo(level, pos.x, pos.y, pos.z, yaw, 0.0f);
                level.playSound(null, player.blockPosition(), GAGSounds.TELEPORT.get(), SoundSource.PLAYERS, 0.5f, 0.5f);
                if (!stack.isEmpty() && !creative) {
                    player.getCooldowns().addCooldown(stack.getItem(), ((Integer)GAGConfig.Hearthstone.COOLDOWN.get()).intValue());
                }
            } else {
                player.sendSystemMessage((Component)this.getTranslation("too_weak", new Object[0]).withStyle(ChatFormatting.RED));
                level.playSound(null, player.blockPosition(), GAGSounds.TELEPORT_FAIL.get(), SoundSource.PLAYERS, 0.6f, 1.0f);
            }
        } else {
            player.sendSystemMessage((Component)this.getTranslation("too_weak", new Object[0]).withStyle(ChatFormatting.RED));
            level.playSound(null, player.blockPosition(), GAGSounds.TELEPORT_FAIL.get(), SoundSource.PLAYERS, 0.6f, 1.0f);
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        GAGUtil.appendInfoTooltip(tooltip, List.of(this.getTranslation("info", new Object[0]).withStyle(GAGUtil.TOOLTIP_MAIN), Component.translatable((String)"info.gag.supports_unbreaking").withStyle(GAGUtil.TOOLTIP_EXTRA)));
    }

    public Component getTargetText(Player player, ItemStack stack) {
        return this.getTranslation("target.bound", this.getTranslation("target.respawn", new Object[0]).withStyle(GAGUtil.COLOUR_TRUE)).withStyle(GAGUtil.COLOUR_INFO);
    }

    @Override
    public List<Component> getHoldingTooltip(Player player, ItemStack stack) {
        return List.of(stack.getHoverName(), this.getTargetText(player, stack));
    }

    @Override
    public List<Component> getUsingTooltip(Player player, ItemStack stack, int useTicks) {
        int totalUseTicks = this.getUseDuration(stack);
        useTicks = Math.min(useTicks, totalUseTicks);
        Component warmupText = GAGUtil.asStyledValue(useTicks, totalUseTicks, String.format("%.2f", (double)(totalUseTicks - useTicks) / 20.0));
        return List.of(stack.getHoverName(), this.getTargetText(player, stack), this.getTranslation("warmup", warmupText).withStyle(GAGUtil.TOOLTIP_MAIN));
    }

    protected MutableComponent getTranslation(String key, Object ... args) {
        return Component.translatable((String)("item.gag.hearthstone." + key), (Object[])args);
    }
}

