/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.List;
import java.util.function.UnaryOperator;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.entity.FishingDynamiteEntity;
import ky.someone.mods.gag.entity.MiningDynamiteEntity;
import ky.someone.mods.gag.item.DynamiteItem;
import ky.someone.mods.gag.item.EnergizedHearthstoneItem;
import ky.someone.mods.gag.item.EscapeRopeItem;
import ky.someone.mods.gag.item.HearthstoneItem;
import ky.someone.mods.gag.item.LabelingToolItem;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.item.RepellingItem;
import ky.someone.mods.gag.item.TemporalPouchItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public interface ItemRegistry {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"gag");
    public static final DeferredItem<TemporalPouchItem> TIME_SAND_POUCH = ITEMS.register("time_sand_pouch", TemporalPouchItem::new);
    public static final DeferredItem<Item> ESCAPE_ROPE = ITEMS.register("escape_rope", EscapeRopeItem::new);
    public static final DeferredItem<Item> HEARTHSTONE = ITEMS.register("hearthstone", () -> new HearthstoneItem());
    public static final DeferredItem<Item> ENERGIZED_HEARTHSTONE = ITEMS.register("energized_hearthstone", EnergizedHearthstoneItem::new);
    public static final DeferredItem<Item> SACRED_SALT = ItemRegistry.repelling("sacred_salt", p -> p.stacksTo(16).rarity(Rarity.UNCOMMON), 800, 1, false);
    public static final DeferredItem<Item> SACRED_SALVE = ItemRegistry.repelling("sacred_salve", p -> p.stacksTo(4).rarity(Rarity.RARE), 2400, 2, true);
    public static final DeferredItem<Item> SACRED_BALM = ItemRegistry.repelling("sacred_balm", p -> p.stacksTo(4).rarity(Rarity.RARE), 7200, 0, true);
    public static final DeferredItem<Item> MINING_DYNAMITE = ItemRegistry.dynamite("mining_dynamite", MiningDynamiteEntity::new, List.of(Component.translatable((String)"item.gag.mining_dynamite.info").withStyle(GAGUtil.TOOLTIP_MAIN)), 1.5);
    public static final DeferredItem<Item> FISHING_DYNAMITE = ItemRegistry.dynamite("fishing_dynamite", FishingDynamiteEntity::new, List.of(Component.translatable((String)"item.gag.fishing_dynamite.info").withStyle(GAGUtil.TOOLTIP_MAIN)), 1.5);
    public static final DeferredItem<Item> LABELING_TOOL = ITEMS.register("labeling_tool", LabelingToolItem::new);
    public static final DeferredItem<Item> PIGMENT_JAR = ITEMS.register("pigment_jar", PigmentJarItem::new);

    private static DeferredItem<Item> repelling(String name, UnaryOperator<Item.Properties> properties, int duration, int amplifier, boolean hasTooltip) {
        return ITEMS.register(name, () -> new RepellingItem((Item.Properties)properties.apply(new Item.Properties()), duration, amplifier, hasTooltip));
    }

    private static DeferredItem<Item> dynamite(String name, DynamiteItem.EntityFactory factory, List<Component> tooltip, double throwSpeed) {
        return ITEMS.register(name, () -> new DynamiteItem(new Item.Properties(), factory, tooltip, throwSpeed));
    }
}

