/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.List;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.menu.LabelingMenu;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LabelingToolItem
extends GAGItem
implements MenuProvider {
    public static final Component TITLE = Component.translatable((String)"item.gag.labeling_tool.text_box");
    public static final int XP_COST = 10;

    public LabelingToolItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide && !player.isShiftKeyDown()) {
            ItemStack stack = player.getItemInHand(hand);
            player.openMenu((MenuProvider)this);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        GAGUtil.appendInfoTooltip(tooltip, List.of(Component.translatable((String)"item.gag.labeling_tool.info").withStyle(GAGUtil.TOOLTIP_MAIN)));
    }

    public Component getDisplayName() {
        return TITLE;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new LabelingMenu(i, inventory);
    }
}

