/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.ArrayList;
import java.util.List;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.effect.EffectRegistry;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.sound.GAGSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class RepellingItem
extends GAGItem {
    public final int duration;
    public final int amplifier;
    private final boolean addExtraTooltip;

    public RepellingItem(Item.Properties properties, int duration, int amplifier, boolean addExtraTooltip) {
        super(properties);
        this.duration = duration;
        this.amplifier = amplifier;
        this.addExtraTooltip = addExtraTooltip;
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        ArrayList<Component> infoTooltips = new ArrayList<Component>();
        infoTooltips.add((Component)Component.translatable((String)"info.gag.repelling_item").withStyle(GAGUtil.TOOLTIP_MAIN));
        if (this.addExtraTooltip) {
            infoTooltips.add((Component)Component.translatable((String)(this.getDescriptionId() + ".extra")).withStyle(GAGUtil.TOOLTIP_EXTRA));
        }
        GAGUtil.appendInfoTooltip(tooltip, infoTooltips);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean hasEffect = player.hasEffect(EffectRegistry.REPELLING.get());
        ItemStack stack = player.getItemInHand(hand);
        if (!hasEffect) {
            level.playSound(null, player.blockPosition(), GAGSounds.REPELLING_APPLY.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
            player.addEffect(new MobEffectInstance(EffectRegistry.REPELLING.get(), this.duration, this.amplifier));
            stack.shrink(1);
        }
        return hasEffect ? InteractionResultHolder.fail((Object)stack) : InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }
}

