/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.item.TemporalPouchItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TimeSandItem
extends GAGItem {
    public TimeSandItem() {
        super(new Item.Properties().stacksTo(16));
    }

    public void inventoryTick(ItemStack sand, Level level, Entity entity, int slot, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide) {
                Inventory inv = player.getInventory();
                for (int i = 0; i < inv.getContainerSize(); ++i) {
                    ItemStack maybePouch = inv.getItem(i);
                    if (!maybePouch.is((Item)ItemRegistry.TIME_SAND_POUCH.get())) continue;
                    int oldCount = TemporalPouchItem.getStoredGrains(maybePouch);
                    int toAdd = Math.min((Integer)GAGConfig.SandsOfTime.POUCH_CAPACITY.get() - oldCount, sand.getCount());
                    if (toAdd > 0) {
                        TemporalPouchItem.setStoredGrains(maybePouch, oldCount + toAdd * (Integer)GAGConfig.SandsOfTime.GRAINS_PER_SAND.get());
                        sand.shrink(toAdd);
                    }
                    if (!sand.isEmpty()) continue;
                    return;
                }
                if (!sand.isEmpty() && !player.isCreative() && level.getGameTime() % 10L == 0L && level.random.nextBoolean()) {
                    sand.shrink(1);
                }
            }
        }
    }
}

