/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.misc;

import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record TeleportPos(ResourceLocation level, Vec3 pos, float yaw) {
    @Nullable
    public static TeleportPos fromNbt(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return null;
        }
        ResourceLocation level = new ResourceLocation(nbt.getString("dim"));
        double x = nbt.getDouble("x");
        double y = nbt.getDouble("y");
        double z = nbt.getDouble("z");
        return new TeleportPos(level, new Vec3(x, y, z), nbt.getFloat("yaw"));
    }

    public CompoundTag toNbt() {
        return (CompoundTag)Util.make((Object)new CompoundTag(), nbt -> {
            nbt.putString("dim", this.level.toString());
            nbt.putDouble("x", this.pos.x);
            nbt.putDouble("y", this.pos.y);
            nbt.putDouble("z", this.pos.z);
            nbt.putFloat("yaw", this.yaw);
        });
    }

    @Nullable
    public ServerLevel getLevel(MinecraftServer server) {
        return server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.level));
    }
}

