/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.recipe.pigment;

import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.misc.Pigment;
import ky.someone.mods.gag.recipe.GAGRecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PigmentJarFromDyeRecipe
extends CustomRecipe {
    public PigmentJarFromDyeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean emptyJar = false;
        boolean flint = false;
        boolean milk = false;
        DyeColor dye = null;
        int dyeAmount = 0;
        for (ItemStack stack : container.getItems()) {
            if (!emptyJar && stack.is((Item)ItemRegistry.PIGMENT_JAR.get()) && PigmentJarItem.isEmpty(stack)) {
                emptyJar = true;
                continue;
            }
            if (!flint && stack.is(Items.FLINT)) {
                flint = true;
                continue;
            }
            if (!milk && stack.is(Items.MILK_BUCKET)) {
                milk = true;
                continue;
            }
            Item item = stack.getItem();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                if (dye == null) {
                    dye = dyeItem.getDyeColor();
                    dyeAmount = 1;
                    continue;
                }
                if (dye == dyeItem.getDyeColor()) {
                    ++dyeAmount;
                    continue;
                }
                return false;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return emptyJar && flint && milk && dye != null;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess reg) {
        DyeColor dye = null;
        int amount = 0;
        for (ItemStack stack : container.getItems()) {
            Item item = stack.getItem();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dyeItem = (DyeItem)item;
            if (dye == null) {
                dye = dyeItem.getDyeColor();
                amount = 1;
                continue;
            }
            if (dye == dyeItem.getDyeColor()) {
                ++amount;
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (dye == null) {
            return ItemStack.EMPTY;
        }
        if ((amount *= 4) > 64) {
            return ItemStack.EMPTY;
        }
        return Pigment.forText(dye).withAmount(amount).asJar();
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i >= 2 && j >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return GAGRecipeSerializers.PIGMENT_JAR_FROM_DYE.get();
    }
}

