/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.recipe.pigment;

import java.util.Map;
import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.misc.Pigment;
import ky.someone.mods.gag.recipe.GAGRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PigmentJarLeatherDyingRecipe
extends CustomRecipe {
    private static final Map<Item, Integer> VALID_ITEMS = Map.of(Items.LEATHER_HELMET, 5, Items.LEATHER_CHESTPLATE, 8, Items.LEATHER_LEGGINGS, 7, Items.LEATHER_BOOTS, 4, Items.LEATHER_HORSE_ARMOR, 7);

    public PigmentJarLeatherDyingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack leatherItem = ItemStack.EMPTY;
        boolean hasPigment = false;
        int pigmentAmount = 0;
        for (ItemStack stack : container.getItems()) {
            DyeableLeatherItem item;
            Item item2 = stack.getItem();
            if (item2 instanceof DyeableLeatherItem && VALID_ITEMS.containsKey(item = (DyeableLeatherItem)item2)) {
                if (!leatherItem.isEmpty()) {
                    return false;
                }
                leatherItem = stack;
                continue;
            }
            if (stack.is((Item)ItemRegistry.PIGMENT_JAR.get())) {
                hasPigment = true;
                pigmentAmount += PigmentJarItem.getColorAmount(stack);
                continue;
            }
            item2 = stack.getItem();
            if (item2 instanceof DyeItem) {
                DyeItem dye = (DyeItem)item2;
                pigmentAmount += 4;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return !leatherItem.isEmpty() && hasPigment && pigmentAmount >= VALID_ITEMS.get(leatherItem.getItem());
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess reg) {
        ItemStack leatherItem = ItemStack.EMPTY;
        Pigment output = Pigment.EMPTY;
        for (ItemStack stack : container.getItems()) {
            Pigment pigment;
            DyeableLeatherItem item;
            Item item2 = stack.getItem();
            if (item2 instanceof DyeableLeatherItem && VALID_ITEMS.containsKey(item = (DyeableLeatherItem)item2)) {
                if (!leatherItem.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                leatherItem = stack.copy();
                if (!item.hasCustomColor(stack)) continue;
                Pigment leatherPigment = Pigment.ofRgb(item.getColor(stack), VALID_ITEMS.get(item));
                output = output.mix(leatherPigment);
                continue;
            }
            if (stack.is((Item)ItemRegistry.PIGMENT_JAR.get())) {
                pigment = PigmentJarItem.getPigment(stack);
                output = output.mix(pigment);
                continue;
            }
            pigment = stack.getItem();
            if (!(pigment instanceof DyeItem)) continue;
            DyeItem dye = (DyeItem)pigment;
            Pigment dyePigment = Pigment.forLeather(dye.getDyeColor());
            output = output.mix(dyePigment);
        }
        if (leatherItem.isEmpty() || output.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ((DyeableLeatherItem)leatherItem.getItem()).setColor(leatherItem, output.rgb());
        return leatherItem;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList remaining = NonNullList.withSize((int)container.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = container.getItem(i);
            if (!PigmentJarItem.isNonEmptyJar(stack)) continue;
            remaining.set(i, (Object)((Item)ItemRegistry.PIGMENT_JAR.get()).getDefaultInstance());
        }
        return remaining;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return GAGRecipeSerializers.PIGMENT_JAR_MIXING.get();
    }
}

