/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.recipe.pigment;

import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.misc.Pigment;
import ky.someone.mods.gag.recipe.GAGRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PigmentJarMixingRecipe
extends CustomRecipe {
    public PigmentJarMixingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        int found = 0;
        for (ItemStack stack : container.getItems()) {
            if (stack.is((Item)ItemRegistry.PIGMENT_JAR.get())) {
                if (PigmentJarItem.isEmpty(stack)) continue;
                ++found;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return found >= 2;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess reg) {
        Pigment result = null;
        for (ItemStack stack : container.getItems()) {
            if (!PigmentJarItem.isNonEmptyJar(stack)) continue;
            Pigment pigment = PigmentJarItem.getPigment(stack);
            if (result == null) {
                result = pigment;
                continue;
            }
            result = result.mix(pigment);
        }
        if (result == null) {
            return ItemStack.EMPTY;
        }
        return result.asJar();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList list = NonNullList.withSize((int)container.getContainerSize(), (Object)ItemStack.EMPTY);
        boolean first = true;
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (!stack.is((Item)ItemRegistry.PIGMENT_JAR.get())) continue;
            if (first) {
                first = false;
                continue;
            }
            list.set(i, (Object)((Item)ItemRegistry.PIGMENT_JAR.get()).getDefaultInstance());
        }
        return list;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return GAGRecipeSerializers.PIGMENT_JAR_MIXING.get();
    }
}

