/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.recipe.pigment;

import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.misc.Pigment;
import ky.someone.mods.gag.recipe.GAGRecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PigmentJarSplittingRecipe
extends CustomRecipe {
    public PigmentJarSplittingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean filled = false;
        boolean empty = false;
        for (ItemStack stack : container.getItems()) {
            if (!stack.is((Item)ItemRegistry.PIGMENT_JAR.get())) continue;
            if (PigmentJarItem.isEmpty(stack)) {
                if (empty) {
                    return false;
                }
                empty = true;
                continue;
            }
            if (filled) {
                return false;
            }
            filled = true;
        }
        return filled && empty;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess reg) {
        for (ItemStack stack : container.getItems()) {
            Pigment pigment;
            if (!stack.is((Item)ItemRegistry.PIGMENT_JAR.get()) || (pigment = PigmentJarItem.getPigment(stack)) == null || pigment.isEmpty()) continue;
            Pigment newStack = pigment.withAmount(pigment.amount() / 2);
            return newStack.asJar().copyWithCount(2);
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return GAGRecipeSerializers.PIGMENT_JAR_SPLITTING.get();
    }
}

