/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.world;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.saveddata.SavedData;

public class GAGPointOfInterestStorage
extends SavedData {
    private static final String FILE_NAME = "gag_poi_info";
    private final Map<BlockPos, Block> pois = new HashMap<BlockPos, Block>();
    private final Level level;

    public GAGPointOfInterestStorage(Level level) {
        this.level = level;
    }

    public static GAGPointOfInterestStorage get(ServerLevel level) {
        return (GAGPointOfInterestStorage)level.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new GAGPointOfInterestStorage((Level)level), tag -> GAGPointOfInterestStorage.load((Level)level, tag)), FILE_NAME);
    }

    public Block add(BlockPos pos, Block block) {
        this.setDirty();
        return this.pois.put(pos, block);
    }

    public boolean removeIfPresent(BlockPos pos) {
        this.setDirty();
        return this.pois.remove(pos) != null;
    }

    public Optional<BlockPos> checkNearbyPOIs(Block block, BlockPos pos, int radius) {
        for (Map.Entry<BlockPos, Block> poi : this.pois.entrySet()) {
            if (poi.getValue() != block || !(poi.getKey().distSqr((Vec3i)pos) < (double)(radius * radius))) continue;
            return Optional.of(poi.getKey());
        }
        return Optional.empty();
    }

    public static GAGPointOfInterestStorage load(Level level, CompoundTag nbt) {
        GAGPointOfInterestStorage storage = new GAGPointOfInterestStorage(level);
        if (nbt.contains("pois")) {
            ListTag list = nbt.getList("pois", 10);
            for (Tag tag : list) {
                CompoundTag poiTag = (CompoundTag)tag;
                Block block = (Block)storage.blockRegistry().get(ResourceLocation.tryParse((String)poiTag.getString("block")));
                BlockPos pos = BlockPos.of((long)poiTag.getLong("pos"));
                storage.pois.put(pos, block);
            }
        }
        return storage;
    }

    public CompoundTag save(CompoundTag compoundTag) {
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, Block> poi : this.pois.entrySet()) {
            list.add((Object)((Tag)Util.make((Object)new CompoundTag(), tag -> {
                tag.putString("block", this.blockRegistry().getKey((Object)((Block)poi.getValue())).toString());
                tag.putLong("pos", ((BlockPos)poi.getKey()).asLong());
            })));
        }
        compoundTag.put("pois", (Tag)list);
        return compoundTag;
    }

    private Registry<Block> blockRegistry() {
        return this.level.registryAccess().registryOrThrow(Registries.BLOCK);
    }
}

