/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore;

import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.DistExecutor;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.Side;
import team.creative.creativecore.client.ClientLoader;
import team.creative.creativecore.common.CommonLoader;

public class CreativeForgeLoader
implements ICreativeLoader {
    @Override
    public Side getOverallSide() {
        return FMLEnvironment.dist.isClient() ? Side.CLIENT : Side.SERVER;
    }

    @Override
    public void registerDisplayTest(Supplier<String> suppliedVersion, BiPredicate<String, Boolean> remoteVersionTest) {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(suppliedVersion, remoteVersionTest));
    }

    @Override
    public String ignoreServerNetworkConstant() {
        return "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31";
    }

    @Override
    public void register(CommonLoader loader) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(x -> loader.onInitialize());
    }

    @Override
    public void registerClient(ClientLoader loader) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(x -> loader.onInitializeClient());
            NeoForge.EVENT_BUS.addListener(x -> loader.registerClientCommands(x.getDispatcher()));
        });
    }

    @Override
    public void registerClientTick(Runnable run) {
        NeoForge.EVENT_BUS.addListener(x -> {
            if (x.phase == TickEvent.Phase.START) {
                run.run();
            }
        });
    }

    @Override
    public void registerClientRenderGui(Consumer run) {
        NeoForge.EVENT_BUS.addListener(x -> run.accept(x.getGuiGraphics()));
    }

    @Override
    public void registerClientRenderStart(Runnable run) {
        NeoForge.EVENT_BUS.addListener(x -> {
            if (x.phase == TickEvent.Phase.START) {
                run.run();
            }
        });
    }

    @Override
    public void registerLevelTick(Consumer<ServerLevel> consumer) {
        NeoForge.EVENT_BUS.addListener(x -> {
            Level patt3727$temp;
            if (x.phase == TickEvent.Phase.END && (patt3727$temp = x.level) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt3727$temp;
                consumer.accept(level);
            }
        });
    }

    @Override
    public void registerLevelTickStart(Consumer<ServerLevel> consumer) {
        NeoForge.EVENT_BUS.addListener(x -> {
            Level patt4028$temp;
            if (x.phase == TickEvent.Phase.START && (patt4028$temp = x.level) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt4028$temp;
                consumer.accept(level);
            }
        });
    }

    @Override
    public void registerUnloadLevel(Consumer<LevelAccessor> consumer) {
        NeoForge.EVENT_BUS.addListener(x -> consumer.accept(x.getLevel()));
    }

    @Override
    public void registerLoadLevel(Consumer<LevelAccessor> consumer) {
        NeoForge.EVENT_BUS.addListener(x -> consumer.accept(x.getLevel()));
    }

    public void registerListener(Consumer consumer) {
        NeoForge.EVENT_BUS.addListener(consumer);
    }

    @Override
    public void registerClientStarted(Runnable run) {
        run.run();
    }

    @Override
    public void postForge(Event event) {
        NeoForge.EVENT_BUS.post(event);
    }

    @Override
    public boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    @Override
    public float getFluidViscosityMultiplier(Fluid fluid, Level level) {
        return (float)fluid.getFluidType().getViscosity() / 1000.0f;
    }

    @Override
    public void registerKeybind(Supplier<KeyMapping> supplier) {
        Minecraft.getInstance().options.keyMappings = (KeyMapping[])ArrayUtils.add((Object[])Minecraft.getInstance().options.keyMappings, (Object)supplier.get());
    }

    @Override
    public Side getEffectiveSide() {
        return EffectiveSide.get().isClient() ? Side.CLIENT : Side.SERVER;
    }
}

