/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.common.util.mc.ColorUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiRenderHelper {
    private static final Minecraft mc = Minecraft.getInstance();

    public static Font getFont() {
        return GuiRenderHelper.mc.font;
    }

    public static void drawItemStack(PoseStack mat, ItemStack stack, float alpha) {
        boolean flag;
        ItemRenderer renderer = mc.getItemRenderer();
        mc.getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        PoseStack matrix = RenderSystem.getModelViewStack();
        matrix.pushPose();
        matrix.mulPoseMatrix(mat.last().pose());
        matrix.translate(0.0f, 0.0f, 100.0f);
        matrix.translate(8.0f, 8.0f, 8.0f);
        matrix.mulPoseMatrix(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        matrix.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        BakedModel bakedmodel = renderer.getModel(stack, null, null, 0);
        boolean bl = flag = !bakedmodel.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        }
        renderer.render(stack, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
        multibuffersource$buffersource.endBatch();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        matrix.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawItemStackDecorations(PoseStack posestack, ItemStack stack) {
        GuiRenderHelper.drawItemStackDecorations(posestack, stack, stack.getCount());
    }

    public static void drawItemStackDecorations(PoseStack posestack, ItemStack stack, int count) {
        if (!stack.isEmpty()) {
            LocalPlayer localplayer;
            float f;
            int x = 0;
            int y = 0;
            if ((long)count != 1L) {
                String s = String.valueOf(count);
                posestack.translate(0.0, 0.0, 200.0);
                MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
                GuiRenderHelper.mc.font.drawInBatch(s, (float)(x + 19 - 2 - GuiRenderHelper.mc.font.width(s)), (float)(y + 6 + 3), 0xFFFFFF, true, posestack.last().pose(), (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                multibuffersource$buffersource.endBatch();
            }
            if (stack.isBarVisible()) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                Tesselator tesselator = Tesselator.getInstance();
                BufferBuilder bufferbuilder = tesselator.getBuilder();
                int i = stack.getBarWidth();
                int j = stack.getBarColor();
                GuiRenderHelper.colorRect(posestack, bufferbuilder, x + 2, y + 13, 13, 2, 0, 0, 0, 255);
                GuiRenderHelper.colorRect(posestack, bufferbuilder, x + 2, y + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
            }
            float f2 = f = (localplayer = Minecraft.getInstance().player) == null ? 0.0f : localplayer.getCooldowns().getCooldownPercent(stack.getItem(), Minecraft.getInstance().getFrameTime());
            if (f > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tesselator tesselator1 = Tesselator.getInstance();
                BufferBuilder bufferbuilder1 = tesselator1.getBuilder();
                GuiRenderHelper.colorRect(posestack, bufferbuilder1, x, y + Mth.floor((float)(16.0f * (1.0f - f))), 16, Mth.ceil((float)(16.0f * f)), 255, 255, 255, 127);
                RenderSystem.enableDepthTest();
            }
        }
    }

    public static void drawStringCentered(PoseStack stack, String text, float width, float height, int color, boolean shadow) {
        int dotWith;
        int textWidth = GuiRenderHelper.mc.font.width((String)text);
        if ((float)textWidth > width && textWidth > (dotWith = GuiRenderHelper.mc.font.width("..."))) {
            int charWidth;
            StringBuilder builder = new StringBuilder();
            textWidth = 0;
            for (int i = 0; i < ((String)text).length() && (float)((charWidth = GuiRenderHelper.mc.font.width("" + ((String)text).charAt(i))) + textWidth + dotWith) < width; ++i) {
                builder.append(((String)text).charAt(i));
                textWidth += charWidth;
            }
            text = builder + "...";
        }
        MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        Font font = GuiRenderHelper.mc.font;
        float f = width / 2.0f - (float)(GuiRenderHelper.mc.font.width((String)text) / 2);
        float f2 = height / 2.0f;
        Objects.requireNonNull(GuiRenderHelper.mc.font);
        font.drawInBatch((String)text, f, f2 - (float)(9 / 2), -1, shadow, stack.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        buffer.endBatch();
    }

    public static void horizontalGradientRect(PoseStack pose, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        GuiRenderHelper.horizontalGradientRect(pose.last().pose(), bufferbuilder, x, y, x2, y2, 0, colorFrom, colorTo);
        tesselator.end();
    }

    public static void horizontalGradientRect(Matrix4f matrix, BufferBuilder builder, int x, int y, int x2, int y2, int z, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.vertex(matrix, (float)x2, (float)y, (float)z).color(f5, f6, f7, f4).endVertex();
        builder.vertex(matrix, (float)x, (float)y, (float)z).color(f1, f2, f3, f).endVertex();
        builder.vertex(matrix, (float)x, (float)y2, (float)z).color(f1, f2, f3, f).endVertex();
        builder.vertex(matrix, (float)x2, (float)y2, (float)z).color(f5, f6, f7, f4).endVertex();
    }

    public static void verticalGradientRect(PoseStack pose, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        GuiRenderHelper.verticalGradientRect(pose.last().pose(), bufferbuilder, x, y, x2, y2, 0, colorFrom, colorTo);
        tesselator.end();
    }

    public static void verticalGradientRect(Matrix4f matrix, BufferBuilder builder, int x, int y, int x2, int y2, int z, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.vertex(matrix, (float)x2, (float)y, (float)z).color(f1, f2, f3, f).endVertex();
        builder.vertex(matrix, (float)x, (float)y, (float)z).color(f1, f2, f3, f).endVertex();
        builder.vertex(matrix, (float)x, (float)y2, (float)z).color(f5, f6, f7, f4).endVertex();
        builder.vertex(matrix, (float)x2, (float)y2, (float)z).color(f5, f6, f7, f4).endVertex();
    }

    public static void horizontalGradientMaskRect(PoseStack pose, int x, int y, int x2, int y2, int color, int mask) {
        GuiRenderHelper.horizontalGradientRect(pose, x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    public static void colorRect(PoseStack pose, int x, int y, int width, int height, int color) {
        GuiRenderHelper.colorRect(pose, Tesselator.getInstance().getBuilder(), x, y, x + width, y + height, ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), ColorUtils.alpha(color));
    }

    public static void colorRect(PoseStack pose, BufferBuilder builder, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        Matrix4f mat = pose.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.vertex(mat, (float)x, (float)y, 0.0f).color(red, green, blue, alpha).endVertex();
        builder.vertex(mat, (float)x, (float)(y + height), 0.0f).color(red, green, blue, alpha).endVertex();
        builder.vertex(mat, (float)(x + width), (float)(y + height), 0.0f).color(red, green, blue, alpha).endVertex();
        builder.vertex(mat, (float)(x + width), (float)y, 0.0f).color(red, green, blue, alpha).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)builder.end());
    }

    private static void textureRect(PoseStack pose, int x, int y, int z, int width, int height, float u, float v, int textureWidth, int textureHeight) {
        GuiRenderHelper.textureRect(pose, x, x + width, y, y + height, z, u, v, width, height, textureWidth, textureHeight);
    }

    public static void textureRect(PoseStack pose, int x, int y, int width, int height, float u, float v) {
        GuiRenderHelper.textureRect(pose, x, y, 0, width, height, u, v, 256, 256);
    }

    public static void textureRect(PoseStack pose, int x, int y, int width, int height, float u, float v, float u2, float v2) {
        GuiRenderHelper.textureRect(pose, x, x + width, y, y + height, 0, u, v, u2, v2, 256, 256);
    }

    private static void textureRect(PoseStack pose, int x, int x2, int y, int y2, int z, float u, float v, float u2, float v2, int textureWidth, int textureHeight) {
        GuiRenderHelper.drawTextureRect(pose.last().pose(), x, x2, y, y2, z, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight);
    }

    private static void textureRect(PoseStack pose, int x, int x2, int y, int y2, int z, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        GuiRenderHelper.drawTextureRect(pose.last().pose(), x, x2, y, y2, z, u / (float)textureWidth, (u + (float)uWidth) / (float)textureWidth, v / (float)textureHeight, (v + (float)vHeight) / (float)textureHeight);
    }

    private static void drawTextureRect(Matrix4f matrix, int x, int x2, int y, int y2, int z, float u, float u2, float v, float v2) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.vertex(matrix, (float)x, (float)y2, (float)z).uv(u, v2).endVertex();
        bufferbuilder.vertex(matrix, (float)x2, (float)y2, (float)z).uv(u2, v2).endVertex();
        bufferbuilder.vertex(matrix, (float)x2, (float)y, (float)z).uv(u2, v).endVertex();
        bufferbuilder.vertex(matrix, (float)x, (float)y, (float)z).uv(u, v).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferbuilder.end());
    }
}

