/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.text;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.ComponentCollector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.util.StringDecomposer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.client.render.text.Linebreaker;
import team.creative.creativecore.client.render.text.WidthLimitedCharSink;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.util.text.AdvancedComponentHelper;
import team.creative.creativecore.common.util.text.content.AdvancedContent;
import team.creative.creativecore.common.util.text.content.AdvancedContentConsumer;
import team.creative.creativecore.common.util.text.content.AdvancedFormattedText;
import team.creative.creativecore.common.util.type.list.SingletonList;

public class CompiledText {
    public static final CompiledText EMPTY = new CompiledText(0, 0){
        {
            this.original = Collections.EMPTY_LIST;
            this.lines = Collections.EMPTY_LIST;
        }

        @Override
        public void setText(Component component) {
        }

        @Override
        public void setText(List<Component> components) {
        }

        @Override
        protected void compile() {
        }

        @Override
        public int getTotalHeight() {
            return 0;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(PoseStack stack) {
        }
    };
    private int maxWidth;
    private int maxHeight;
    private int usedWidth;
    private int usedHeight;
    private int lineSpacing = 2;
    private boolean shadow = true;
    private int defaultColor = -1;
    private Align align = Align.LEFT;
    private VAlign valign = VAlign.TOP;
    protected List<CompiledLine> lines;
    protected List<Component> original;

    private static int width(FormattedText text) {
        if (text instanceof AdvancedFormattedText) {
            AdvancedFormattedText adv = (AdvancedFormattedText)text;
            return adv.width(AdvancedComponentHelper.SPLITTER.width, Style.EMPTY);
        }
        return Mth.ceil((float)AdvancedComponentHelper.SPLITTER.stringWidth(text));
    }

    private static int lineHeight(FormattedText text) {
        Component comp;
        ComponentContents componentContents;
        if (text instanceof AdvancedContent) {
            AdvancedContent adv = (AdvancedContent)text;
            return adv.height();
        }
        if (text instanceof Component && (componentContents = (comp = (Component)text).getContents()) instanceof AdvancedContent) {
            AdvancedContent adv = (AdvancedContent)componentContents;
            return adv.height();
        }
        return AdvancedComponentHelper.SPLITTER.lineHeight;
    }

    public CompiledText(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        this.setText(Collections.EMPTY_LIST);
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public void setDimension(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        this.compile();
    }

    public int getMaxWidht() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setDefaultColor(int color) {
        this.defaultColor = color;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public void setVAlign(VAlign valign) {
        this.valign = valign;
    }

    public void setText(Component component) {
        this.setText(new SingletonList<Component>(component));
    }

    public void setText(List<Component> components) {
        this.original = components;
        this.compile();
    }

    protected void compile() {
        if (CreativeCore.loader().getOverallSide().isServer()) {
            return;
        }
        ArrayList<Component> copy = new ArrayList<Component>();
        for (Component component : this.original) {
            copy.add(AdvancedComponentHelper.copy(component));
        }
        this.lines = new ArrayList<CompiledLine>();
        this.compileNext(null, true, copy);
    }

    @OnlyIn(value=Dist.CLIENT)
    private CompiledLine compileNext(CompiledLine currentLine, boolean newLine, List<? extends FormattedText> components) {
        for (FormattedText formattedText : components) {
            if (newLine) {
                currentLine = new CompiledLine();
                this.lines.add(currentLine);
            }
            currentLine = this.compileNext(currentLine, formattedText);
        }
        return currentLine;
    }

    @OnlyIn(value=Dist.CLIENT)
    private CompiledLine compileNext(CompiledLine currentLine, boolean newLine, FormattedText component) {
        if (newLine) {
            currentLine = new CompiledLine();
            this.lines.add(currentLine);
        }
        return this.compileNext(currentLine, component);
    }

    private CompiledLine compileNext(CompiledLine currentLine, FormattedText component) {
        FormattedText next;
        ArrayList siblings = null;
        if (component instanceof Component && !((Component)component).getSiblings().isEmpty()) {
            siblings = new ArrayList(((Component)component).getSiblings());
            ((Component)component).getSiblings().clear();
        }
        if ((next = currentLine.add(component)) != null) {
            currentLine = new CompiledLine();
            this.lines.add(currentLine);
            currentLine = this.compileNext(currentLine, false, next);
        }
        if (siblings != null) {
            currentLine = this.compileNext(currentLine, false, siblings);
        }
        return currentLine;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTotalHeight() {
        int height = -this.lineSpacing;
        for (CompiledLine line : this.lines) {
            height += line.height + this.lineSpacing;
        }
        return height;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack stack) {
        if (this.lines == null) {
            return;
        }
        this.usedWidth = 0;
        this.usedHeight = -this.lineSpacing;
        int totalHeight = this.getTotalHeight();
        stack.pushPose();
        float y = Math.max(0, switch (this.valign) {
            case VAlign.CENTER -> this.maxHeight / 2 - totalHeight / 2;
            case VAlign.BOTTOM -> this.maxHeight - totalHeight;
            default -> 0;
        });
        stack.translate(0.0f, y, 0.0f);
        this.usedHeight += (int)y;
        for (CompiledLine line : this.lines) {
            switch (this.align) {
                case CENTER: {
                    int x = this.maxWidth / 2 - line.width / 2;
                    stack.translate((float)x, 0.0f, 0.0f);
                    line.render(stack);
                    stack.translate((float)(-x), 0.0f, 0.0f);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                    break;
                }
                case RIGHT: {
                    int x = this.maxWidth - line.width;
                    stack.translate((float)x, 0.0f, 0.0f);
                    line.render(stack);
                    stack.translate((float)(-x), 0.0f, 0.0f);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                    break;
                }
                default: {
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, line.width);
                }
            }
            int height = line.height + this.lineSpacing;
            stack.translate(0.0f, (float)height, 0.0f);
            this.usedHeight += height;
            if (this.usedHeight <= this.maxHeight) continue;
            break;
        }
        stack.popPose();
        RenderSystem.enableBlend();
    }

    @OnlyIn(value=Dist.CLIENT)
    public FormattedTextSplit splitByWidth(FormattedText text, int width, Style style, final boolean force) {
        final WidthLimitedCharSink charSink = new WidthLimitedCharSink(width, Minecraft.getInstance().font.getSplitter());
        final ComponentCollector head = new ComponentCollector();
        final ComponentCollector tail = new ComponentCollector();
        if (text instanceof Component) {
            Component comp = (Component)text;
            AdvancedComponentHelper.visit(comp, new AdvancedContentConsumer(){

                public Optional accept(Style style, AdvancedContent content) {
                    if (charSink.accept(style, content) || force) {
                        head.append(content.asText());
                    } else {
                        tail.append(content.asText());
                    }
                    return Optional.empty();
                }

                public Optional accept(Style style, String text) {
                    charSink.resetPosition();
                    if (!StringDecomposer.iterateFormatted((String)text, (Style)style, (FormattedCharSink)charSink)) {
                        Linebreaker breaker = charSink.lastBreaker();
                        if (force || breaker != null) {
                            String sTail;
                            String sHead;
                            if (breaker != null) {
                                int pos = charSink.lastBreakerPos();
                                sHead = text.substring(0, pos + (breaker.includeChar && breaker.head ? 1 : 0));
                                sTail = text.substring(pos + (breaker.includeChar && !breaker.head ? 0 : 1));
                            } else {
                                sHead = text.substring(0, charSink.getPosition());
                                sTail = text.substring(charSink.getPosition());
                            }
                            if (!sHead.isEmpty()) {
                                head.append(FormattedText.of((String)sHead, (Style)style));
                            }
                            if (!sTail.isEmpty()) {
                                tail.append(FormattedText.of((String)sTail, (Style)style));
                            }
                        } else {
                            tail.append(FormattedText.of((String)text, (Style)style));
                        }
                    } else if (!text.isEmpty()) {
                        head.append(FormattedText.of((String)text, (Style)style));
                    }
                    return Optional.empty();
                }
            }, style);
        } else {
            text.visit((FormattedText.StyledContentConsumer)new FormattedText.StyledContentConsumer<FormattedText>(){

                public Optional<FormattedText> accept(Style style, String text) {
                    charSink.resetPosition();
                    if (!StringDecomposer.iterateFormatted((String)text, (Style)style, (FormattedCharSink)charSink)) {
                        Linebreaker breaker = charSink.lastBreaker();
                        if (force || breaker != null) {
                            String sTail;
                            String sHead;
                            if (breaker != null) {
                                int pos = charSink.lastBreakerPos();
                                sHead = text.substring(0, pos + (breaker.includeChar && breaker.head ? 1 : 0));
                                sTail = text.substring(pos + (breaker.includeChar && !breaker.head ? 0 : 1));
                            } else {
                                sHead = text.substring(0, charSink.getPosition());
                                sTail = text.substring(charSink.getPosition());
                            }
                            if (!sHead.isEmpty()) {
                                head.append(FormattedText.of((String)sHead, (Style)style));
                            }
                            if (!sTail.isEmpty()) {
                                tail.append(FormattedText.of((String)sTail, (Style)style));
                            }
                        } else {
                            tail.append(FormattedText.of((String)text, (Style)style));
                        }
                    } else if (!text.isEmpty()) {
                        head.append(FormattedText.of((String)text, (Style)style));
                    }
                    return Optional.empty();
                }
            }, style);
        }
        FormattedText headText = head.getResult();
        FormattedText tailText = tail.getResult();
        if (headText == null && tailText == null) {
            return null;
        }
        return new FormattedTextSplit(headText, tailText);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTotalWidth() {
        return this.calculateWidth(0, true, this.original);
    }

    @OnlyIn(value=Dist.CLIENT)
    private int calculateWidth(int width, boolean newLine, List<? extends FormattedText> components) {
        for (FormattedText formattedText : components) {
            int result = CompiledText.width(formattedText);
            if (newLine) {
                width = Math.max(width, result);
                continue;
            }
            width += result;
        }
        return width;
    }

    public CompiledText copy() {
        CompiledText copy = new CompiledText(this.maxWidth, this.maxHeight);
        copy.align = this.align;
        copy.valign = this.valign;
        copy.defaultColor = this.defaultColor;
        copy.lineSpacing = this.lineSpacing;
        copy.shadow = this.shadow;
        ArrayList<Component> components = new ArrayList<Component>();
        for (Component component : this.original) {
            components.add((Component)component.copy());
        }
        copy.setText(components);
        return copy;
    }

    public static CompiledText createAnySize() {
        return new CompiledText(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean contains(String search) {
        for (CompiledLine line : this.lines) {
            if (!line.contains(search)) continue;
            return true;
        }
        return false;
    }

    public int getUsedWidth() {
        return this.usedWidth;
    }

    public int getUsedHeight() {
        return this.usedHeight;
    }

    public class CompiledLine {
        private final List<FormattedText> components = new ArrayList<FormattedText>();
        private int height = 0;
        private int width = 0;

        public boolean contains(String search) {
            for (FormattedText text : this.components) {
                if (!text.getString().contains(search)) continue;
                return true;
            }
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(PoseStack pose) {
            Font font = Minecraft.getInstance().font;
            int xOffset = 0;
            MultiBufferSource.BufferSource renderType = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
            for (FormattedText text : this.components) {
                int height = CompiledText.lineHeight(text);
                int width = CompiledText.width(text);
                int yOffset = 0;
                if (height < this.height) {
                    yOffset = (this.height - height) / 2;
                }
                pose.pushPose();
                pose.translate((float)xOffset, (float)yOffset, 0.0f);
                if (text instanceof AdvancedFormattedText) {
                    AdvancedFormattedText adv = (AdvancedFormattedText)text;
                    adv.render(pose, CompiledText.this.defaultColor);
                } else {
                    font.drawInBatch(Language.getInstance().getVisualOrder(text), 0.0f, 0.0f, CompiledText.this.defaultColor, CompiledText.this.shadow, pose.last().pose(), (MultiBufferSource)renderType, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    renderType.endBatch();
                }
                pose.popPose();
                xOffset += width;
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void updateDimension(int width, int height) {
            this.width = Math.max(width, this.width);
            this.height = Math.max(height, this.height);
        }

        public FormattedText add(FormattedText component) {
            int remainingWidth = CompiledText.this.maxWidth - this.width;
            int textWidth = CompiledText.width(component);
            if (remainingWidth >= textWidth) {
                Component comp;
                ComponentContents componentContents;
                if (component instanceof Component && (componentContents = (comp = (Component)component).getContents()) instanceof AdvancedContent) {
                    AdvancedContent adv = (AdvancedContent)componentContents;
                    this.components.add(adv.asText());
                } else {
                    this.components.add(component);
                }
                this.updateDimension(this.width + textWidth, CompiledText.lineHeight(component));
                return null;
            }
            FormattedTextSplit split = CompiledText.this.splitByWidth(component, remainingWidth, Style.EMPTY, this.width == 0);
            if (split != null && (split.head != null || this.width == 0)) {
                if (split.head != null) {
                    this.updateDimension(this.width + CompiledText.width(split.head), CompiledText.lineHeight(split.head));
                    this.components.add(split.head);
                    return split.tail;
                }
                this.updateDimension(this.width + CompiledText.width(split.tail), CompiledText.lineHeight(split.tail));
                this.components.add(split.tail);
                return null;
            }
            if (this.width == 0) {
                return null;
            }
            return component;
        }
    }

    public record FormattedTextSplit(FormattedText head, FormattedText tail) {
    }
}

