/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntitySound
extends AbstractTickableSoundInstance {
    private final Entity entity;

    public EntitySound(SoundEvent event, Entity entity, float volume, float pitch, SoundSource category) {
        super(event, category, SoundInstance.createUnseededRandom());
        this.entity = entity;
        this.volume = volume;
        this.pitch = pitch;
    }

    public void tick() {
        Minecraft mc = Minecraft.getInstance();
        Entity view = mc.cameraEntity;
        float partialTicks = mc.getFrameTime();
        if (view == null) {
            this.stop();
            return;
        }
        Vec3 viewVec = view.getEyePosition(partialTicks);
        AABB bb = this.entity.getBoundingBox();
        if (bb.contains(viewVec)) {
            this.x = (float)viewVec.x;
            this.y = (float)viewVec.y;
            this.z = (float)viewVec.z;
            return;
        }
        this.x = viewVec.x > bb.minX ? (viewVec.x > bb.maxX ? (double)((float)bb.maxX) : (double)((float)viewVec.x)) : (double)((float)bb.minX);
        this.y = viewVec.y > bb.minY ? (viewVec.y > bb.maxY ? (double)((float)bb.maxY) : (double)((float)viewVec.y)) : (double)((float)bb.minY);
        this.z = viewVec.z > bb.minZ ? (viewVec.z > bb.maxZ ? (double)((float)bb.maxZ) : (double)((float)viewVec.z)) : (double)((float)bb.minZ);
    }
}

