/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.common.gui.manager.GuiManagerItem;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;
import team.creative.creativecore.common.util.math.geo.Rect;

public abstract class GuiLayer
extends GuiParent {
    public static final int MINIMUM_LAYER_SPACING = 10;
    @OnlyIn(value=Dist.CLIENT)
    public GuiStyle style;
    public final Rect rect;
    private final GuiSyncHolder.GuiSyncHolderLayer sync = new GuiSyncHolder.GuiSyncHolderLayer(this);
    private HashMap<GuiManager.GuiManagerType, GuiManager> managers;

    protected static void collectInventories(Iterable<GuiChildControl> parent, List<IGuiInventory> inventories) {
        for (GuiChildControl child : parent) {
            if (child.control instanceof IGuiInventory) {
                inventories.add((IGuiInventory)((Object)child.control));
                continue;
            }
            if (!(child.control instanceof GuiParent)) continue;
            GuiLayer.collectInventories((GuiParent)child.control, inventories);
        }
    }

    public GuiLayer(String name) {
        super(name, GuiFlow.STACK_X);
        this.rect = new Rect(0.0, 0.0, 0.0, 0.0);
        if (CreativeCore.loader().getOverallSide().isClient()) {
            this.style = GuiStyle.getStyle(name);
        }
    }

    public GuiLayer(String name, int width, int height) {
        super(name, GuiFlow.STACK_X);
        this.rect = new Rect(0.0, 0.0, 0.0, 0.0);
        this.setDim(width, height);
        if (CreativeCore.loader().getOverallSide().isClient()) {
            this.style = GuiStyle.getStyle(name);
        }
    }

    @Override
    public GuiControl setDim(int width, int height) {
        this.rect.maxX = width;
        this.rect.maxY = height;
        return super.setDim(width, height);
    }

    public Iterable<IGuiInventory> inventoriesToInsert() {
        ArrayList<IGuiInventory> inventories = new ArrayList<IGuiInventory>();
        GuiLayer.collectInventories(this, inventories);
        return inventories;
    }

    public Iterable<IGuiInventory> inventoriesToExract() {
        ArrayList<IGuiInventory> inventories = new ArrayList<IGuiInventory>();
        GuiLayer.collectInventories(this, inventories);
        Collections.reverse(inventories);
        return inventories;
    }

    public boolean has(GuiManager.GuiManagerType type) {
        if (this.managers == null) {
            return false;
        }
        return this.managers.containsKey(type);
    }

    public <T extends GuiManager> T getOrCreate(GuiManager.GuiManagerType<T> type) {
        GuiManager manager;
        if (this.managers == null) {
            this.managers = new HashMap();
        }
        if ((manager = this.managers.get(type)) == null) {
            manager = (GuiManager)type.factory().apply(this);
            this.managers.put(type, manager);
        }
        return (T)manager;
    }

    public GuiManagerItem itemManager() {
        return this.getOrCreate(GuiManager.ITEM);
    }

    public Iterable<GuiManager> managers() {
        if (this.managers == null) {
            return Collections.EMPTY_LIST;
        }
        return this.managers.values();
    }

    public GuiSyncHolder.GuiSyncHolderLayer getSyncHolder() {
        return this.sync;
    }

    public int getWidth() {
        return (int)this.rect.getWidth();
    }

    public int getHeight() {
        return (int)this.rect.getHeight();
    }

    @Override
    public void init() {
        this.create();
        super.init();
        this.reflow();
    }

    public void reinit() {
        super.init();
        this.reflow();
    }

    @Override
    public void reflow() {
        if (CreativeCore.loader().getOverallSide().isServer()) {
            return;
        }
        Rect screen = Rect.getScreenRect();
        int screenWidth = (int)screen.getWidth() - this.getContentOffset() * 2 - 10;
        int fixedWidth = -1;
        int width = 0;
        if (this.preferred != null) {
            width = fixedWidth = this.preferred.preferredWidth(this, screenWidth);
        }
        if (fixedWidth == -1) {
            width = this.isExpandableX() ? screenWidth : Math.min(screenWidth, this.preferredWidth(screenWidth));
        }
        if (this.preferred != null) {
            int maxWidth;
            int minWidth = this.preferred.minWidth(this, screenWidth);
            if (minWidth != -1) {
                width = Math.max(width, minWidth);
            }
            if ((maxWidth = this.preferred.maxWidth(this, screenWidth)) != -1) {
                width = Math.min(width, maxWidth);
            }
        }
        this.rect.maxX = width + this.getContentOffset() * 2;
        this.flowX(width, this.preferredWidth(fixedWidth != -1 ? fixedWidth : screenWidth));
        int screenHeight = (int)screen.getHeight() - this.getContentOffset() * 2 - 10;
        int fixedHeight = -1;
        int height = 0;
        if (this.preferred != null) {
            height = fixedHeight = this.preferred.preferredHeight(this, width, screenHeight);
        }
        if (fixedHeight == -1) {
            height = this.isExpandableY() ? screenHeight : Math.min(screenHeight, this.preferredHeight(width, screenHeight));
        }
        if (this.preferred != null) {
            int maxHeight;
            int minHeight = this.preferred.minHeight(this, width, screenHeight);
            if (minHeight != -1) {
                height = Math.max(height, minHeight);
            }
            if ((maxHeight = this.preferred.maxHeight(this, width, screenHeight)) != -1) {
                height = Math.min(height, maxHeight);
            }
        }
        this.rect.maxY = height + this.getContentOffset() * 2;
        this.flowY(width, height, this.preferredHeight(width, fixedHeight != -1 ? fixedHeight : screenHeight));
    }

    public abstract void create();

    public void becameTopLayer() {
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.GUI;
    }

    @Override
    public GuiLayer getLayer() {
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiStyle getStyle() {
        return this.style;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        for (GuiManager manager : this.managers()) {
            manager.renderOverlay(graphics, control, rect, mouseX - (int)rect.minX, mouseY - (int)rect.minY);
        }
    }

    public boolean closeLayerUsingEscape() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Options getSettings() {
        return Minecraft.getInstance().options;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasGrayBackground() {
        return true;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (!this.rect.inside(x, y) && !this.isMouseOverHovered(x, y)) {
            this.looseFocus();
            for (GuiManager manager : this.managers()) {
                manager.mouseClickedOutside(x, y);
            }
            return false;
        }
        return super.mouseClicked(rect, x, y, button);
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        super.mouseReleased(rect, x, y, button);
        for (GuiManager manager : this.managers()) {
            manager.mouseReleased(x, y, button);
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.closeLayerUsingEscape()) {
                this.closeTopLayer();
            }
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.getSettings().keyInventory.matches(keyCode, scanCode)) {
            this.closeTopLayer();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLayer() {
        return true;
    }

    @Override
    public void tick() {
        for (GuiManager manager : this.managers()) {
            manager.tick();
        }
        super.tick();
    }

    @Override
    public void closed() {
        for (GuiManager manager : this.managers()) {
            manager.closed();
        }
        super.closed();
    }

    @Override
    public Rect toLayerRect(GuiControl control, Rect rect) {
        GuiChildControl child = this.find(control);
        if (child == null) {
            return rect;
        }
        rect.move(child.rect.minX + this.getOffsetX(), child.rect.minY + this.getOffsetY());
        rect.scale(this.scaleFactor());
        return rect;
    }
}

