/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.parent;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;

public class GuiScrollXY
extends GuiParent {
    public int maxScrollX = 0;
    public SmoothValue scrolledX = new SmoothValue(200L);
    public boolean draggedX;
    public int maxScrollY = 0;
    public SmoothValue scrolledY = new SmoothValue(200L);
    public boolean draggedY;
    public int scrollbarThickness = 3;
    public ControlFormatting.ControlStyleFace scrollbarFace = ControlFormatting.ControlStyleFace.CLICKABLE;
    public boolean alternativeScrolling = false;
    protected int cachedWidth;
    protected int cachedHeight;

    public GuiScrollXY() {
        this("");
    }

    public GuiScrollXY(String name) {
        this(name, GuiFlow.STACK_X);
    }

    public GuiScrollXY(String name, GuiFlow flow) {
        super(name, flow);
    }

    @Override
    public double getOffsetX() {
        return -this.scrolledX.current();
    }

    @Override
    public double getOffsetY() {
        return -this.scrolledY.current();
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED;
    }

    public void onScrolledX() {
        if (this.scrolledX.aimed() < 0.0) {
            this.scrolledX.set(0.0);
        }
        if (this.scrolledX.aimed() > (double)this.maxScrollX) {
            this.scrolledX.set(this.maxScrollX);
        }
    }

    public void onScrolledY() {
        if (this.scrolledY.aimed() < 0.0) {
            this.scrolledY.set(0.0);
        }
        if (this.scrolledY.aimed() > (double)this.maxScrollY) {
            this.scrolledY.set(this.maxScrollY);
        }
    }

    @Override
    public boolean mouseScrolled(Rect rect, double x, double y, double scrolled) {
        if (super.mouseScrolled(rect, x, y, scrolled)) {
            return true;
        }
        this.scroll(rect, scrolled);
        return true;
    }

    public void scroll(Rect rect, double scrolled) {
        if (this.alternativeScrolling) {
            if (Screen.hasShiftDown()) {
                if (this.needsScrollbarX(rect)) {
                    this.scrolledX.set(this.scrolledX.aimed() - scrolled * 10.0);
                    this.onScrolledX();
                }
                return;
            }
            this.scrolledY.set(this.scrolledY.aimed() - scrolled * 10.0);
            this.onScrolledY();
            return;
        }
        boolean shouldScrollY = this.needsScrollbarY(rect);
        if (shouldScrollY) {
            if (scrolled > 0.0 && this.scrolledY.aimed() == 0.0) {
                shouldScrollY = false;
            } else if (scrolled < 0.0 && this.scrolledY.aimed() == (double)this.maxScrollY) {
                shouldScrollY = false;
            }
        }
        if (shouldScrollY) {
            this.scrolledY.set(this.scrolledY.aimed() - scrolled * 10.0);
            this.onScrolledY();
            return;
        }
        this.scrolledX.set(this.scrolledX.aimed() - scrolled * 10.0);
        this.onScrolledX();
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (button == 0 && rect.getHeight() - y <= (double)this.scrollbarThickness && this.needsScrollbarX(rect)) {
            GuiScrollXY.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
            this.draggedX = true;
            return true;
        }
        if (button == 0 && rect.getWidth() - x <= (double)this.scrollbarThickness && this.needsScrollbarY(rect)) {
            GuiScrollXY.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
            this.draggedY = true;
            return true;
        }
        return super.mouseClicked(rect, x, y, button);
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        double percent;
        ControlFormatting formatting;
        GuiStyle style;
        if (this.draggedX) {
            style = this.getStyle();
            formatting = this.getControlFormatting();
            int completeWidth = (int)(rect.getWidth() - (double)(style.getBorder(formatting.border) * 2));
            int scrollThingWidth = Math.max(10, Math.min(completeWidth, (int)((float)completeWidth / (float)this.cachedWidth * (float)completeWidth)));
            if (this.cachedWidth < completeWidth) {
                scrollThingWidth = completeWidth;
            }
            percent = x / (double)(completeWidth - scrollThingWidth);
            this.scrolledX.set((int)(percent * (double)this.maxScrollX));
            this.onScrolledX();
        }
        if (this.draggedY) {
            style = this.getStyle();
            formatting = this.getControlFormatting();
            int completeHeight = (int)(rect.getHeight() - (double)(style.getBorder(formatting.border) * 2));
            int scrollThingHeight = Math.max(10, Math.min(completeHeight, (int)((float)completeHeight / (float)this.cachedHeight * (float)completeHeight)));
            if (this.cachedHeight < completeHeight) {
                scrollThingHeight = completeHeight;
            }
            percent = y / (double)(completeHeight - scrollThingHeight);
            this.scrolledY.set((int)(percent * (double)this.maxScrollY));
            this.onScrolledY();
        }
        super.mouseMoved(rect, x, y);
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        super.mouseReleased(rect, x, y, button);
        this.draggedY = false;
        this.draggedX = false;
    }

    public boolean needsScrollbarX(Rect rect) {
        return (double)this.cachedWidth > rect.getWidth() - (double)(this.getContentOffset() * 2);
    }

    public boolean needsScrollbarY(Rect rect) {
        return (double)this.cachedHeight > rect.getHeight() - (double)(this.getContentOffset() * 2);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, GuiChildControl control, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        double percent;
        PoseStack pose = graphics.pose();
        pose.pushPose();
        super.renderContent(graphics, control, formatting, borderWidth, controlRect, realRect, scale, mouseX, mouseY);
        pose.popPose();
        float controlInvScale = (float)this.scaleFactorInv();
        pose.scale(controlInvScale, controlInvScale, controlInvScale);
        realRect.scissor();
        GuiStyle style = this.getStyle();
        RenderSystem.disableDepthTest();
        this.scrolledX.tick();
        if (this.needsScrollbarX(control.rect)) {
            int completeWidth = control.getWidth() - borderWidth * 2;
            int scrollThingWidth = Math.max(10, Math.min(completeWidth, (int)((float)completeWidth / (float)this.cachedWidth * (float)completeWidth)));
            if (this.cachedWidth < completeWidth) {
                scrollThingWidth = completeWidth;
            }
            percent = this.scrolledX.current() / (double)this.maxScrollX;
            style.get(this.scrollbarFace, false).render(pose, (int)(percent * (double)(completeWidth - scrollThingWidth)) + borderWidth, control.getHeight() - this.scrollbarThickness - borderWidth, scrollThingWidth, this.scrollbarThickness);
            this.maxScrollX = Math.max(0, this.cachedWidth - completeWidth + formatting.padding * 2 + 1);
        }
        this.scrolledY.tick();
        if (this.needsScrollbarY(control.rect)) {
            int completeHeight = control.getHeight() - borderWidth * 2;
            int scrollThingHeight = Math.max(10, Math.min(completeHeight, (int)((float)completeHeight / (float)this.cachedHeight * (float)completeHeight)));
            if (this.cachedHeight < completeHeight) {
                scrollThingHeight = completeHeight;
            }
            percent = this.scrolledY.current() / (double)this.maxScrollY;
            style.get(this.scrollbarFace, false).render(pose, control.getWidth() - this.scrollbarThickness - borderWidth, (int)(percent * (double)(completeHeight - scrollThingHeight)) + borderWidth, this.scrollbarThickness, scrollThingHeight);
            this.maxScrollY = Math.max(0, this.cachedHeight - completeHeight + formatting.padding * 2 + 1);
        }
        float controlScale = (float)this.scaleFactor();
        pose.scale(controlScale, controlScale, controlScale);
        RenderSystem.enableDepthTest();
    }

    @Override
    protected int minWidth(int availableWidth) {
        return 10;
    }

    @Override
    protected int minHeight(int width, int availableHeight) {
        return 10;
    }

    @Override
    public void flowX(int width, int preferred) {
        super.flowX(preferred, preferred);
        this.updateWidth();
    }

    protected void updateWidth() {
        int maxX = 0;
        for (GuiChildControl child : this.controls) {
            maxX = Math.max((int)child.rect.maxX, maxX);
        }
        this.cachedWidth = maxX;
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        super.flowY(this.cachedWidth, preferred, preferred);
        this.updateHeight();
    }

    protected void updateHeight() {
        int maxY = 0;
        for (GuiChildControl child : this.controls) {
            maxY = Math.max((int)child.rect.maxY, maxY);
        }
        this.cachedHeight = maxY;
    }
}

