/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.style.display;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Type;
import java.util.HashMap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.DisplayTexture;
import team.creative.creativecore.common.gui.style.display.DisplayTextureStretch;
import team.creative.creativecore.common.util.math.geo.Rect;

@OnlyIn(value=Dist.CLIENT)
@JsonAdapter(value=StyleDisplayDeserializer.class)
public abstract class StyleDisplay {
    public static final StyleDisplay NONE = new StyleDisplay(){

        @Override
        public void render(PoseStack pose, double x, double y, double width, double height) {
        }
    };
    private static final HashMap<String, Class<? extends StyleDisplay>> types = new HashMap();

    public static void registerType(String id, Class<? extends StyleDisplay> clazz) {
        if (types.containsKey(id)) {
            throw new IllegalArgumentException(id + " is already taken");
        }
        types.put(id, clazz);
    }

    public void render(PoseStack matrix, double width, double height) {
        this.render(matrix, 0.0, 0.0, width, height);
    }

    public void render(PoseStack matrix, Rect origin, Rect rect) {
        this.render(matrix, rect.getWidth(), rect.getHeight());
    }

    public abstract void render(PoseStack var1, double var2, double var4, double var6, double var8);

    static {
        StyleDisplay.registerType("color", DisplayColor.class);
        StyleDisplay.registerType("tex", DisplayTexture.class);
        StyleDisplay.registerType("texs", DisplayTextureStretch.class);
    }

    public static class StyleDisplayDeserializer
    implements JsonDeserializer<StyleDisplay> {
        public StyleDisplay deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                throw new JsonParseException("style display cannot be a property");
            }
            if (!json.getAsJsonObject().has("type")) {
                throw new JsonParseException("missing type in style display");
            }
            Class<? extends StyleDisplay> clazz = types.get(json.getAsJsonObject().get("type").getAsString());
            if (clazz == null) {
                throw new JsonParseException("style display type not found " + json.getAsJsonObject().get("type"));
            }
            return (StyleDisplay)context.deserialize(json, clazz);
        }
    }
}

