/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CreativeNetworkPacket;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.network.CreativePacketWrapper;

public class CreativeNetwork {
    private final HashMap<Class<? extends CreativePacket>, CreativeNetworkPacket> packetTypes = new HashMap();
    private final Logger logger;
    private final String modid;
    private String version;
    private IPayloadRegistrar registrar;
    private int id = 0;

    @OnlyIn(value=Dist.CLIENT)
    private static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public CreativeNetwork(int version, Logger logger, ResourceLocation location) {
        this.logger = logger;
        this.version = "" + version;
        this.modid = location.getNamespace();
        this.logger.debug("Created network " + location);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::register);
    }

    public void register(RegisterPayloadHandlerEvent event) {
        this.registrar = event.registrar(this.modid).versioned(this.version).optional();
        for (CreativeNetworkPacket packet : this.packetTypes.values()) {
            this.registerType(packet);
        }
    }

    private <T extends CreativePacket> void registerType(CreativeNetworkPacket handler) {
        this.registrar.play(handler.id, buffer -> new CreativePacketWrapper(handler, handler.read((FriendlyByteBuf)buffer)), (message, ctx) -> {
            try {
                ctx.workHandler().execute(() -> ((CreativePacket)message.packet()).execute(ctx.player().isPresent() ? (Player)ctx.player().get() : CreativeNetwork.getClientPlayer()));
            }
            catch (Throwable e) {
                CreativeCore.LOGGER.error("Executing a packet ran into an exception", e);
                throw e;
            }
        });
    }

    public <T extends CreativePacket> void registerType(Class<T> classType, Supplier<T> supplier) {
        CreativeNetworkPacket<T> handler = new CreativeNetworkPacket<T>(new ResourceLocation(this.modid, "" + this.id), classType, supplier);
        this.packetTypes.put(classType, handler);
        if (this.registrar != null) {
            this.registerType(handler);
        }
        ++this.id;
    }

    protected <T extends CreativePacket> CreativePacketWrapper<T> wrap(T packet) {
        return new CreativePacketWrapper<T>(this.packetTypes.get(packet.getClass()), packet);
    }

    public void sendToServer(CreativePacket message) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{this.wrap(message)});
    }

    public void sendToClient(CreativePacket message, ServerPlayer player) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{this.wrap(message)});
    }

    public void sendToClient(CreativePacket message, Level level, BlockPos pos) {
        if (level instanceof ISubLevel) {
            this.sendToClientTracking(message, ((ISubLevel)level).getHolder());
        } else {
            this.sendToClient(message, level.getChunkAt(pos));
        }
    }

    public void sendToClient(CreativePacket message, LevelChunk chunk) {
        PacketDistributor.TRACKING_CHUNK.with((Object)chunk).send(new CustomPacketPayload[]{this.wrap(message)});
    }

    public void sendToClientTracking(CreativePacket message, Entity entity) {
        Level level = entity.level();
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            this.sendToClientTracking(message, sub.getHolder());
        } else {
            PacketDistributor.TRACKING_ENTITY.with((Object)entity).send(new CustomPacketPayload[]{this.wrap(message)});
        }
    }

    public void sendToClientTrackingAndSelf(CreativePacket message, Entity entity) {
        Level level = entity.level();
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            this.sendToClientTrackingAndSelf(message, sub.getHolder());
        } else {
            PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)entity).send(new CustomPacketPayload[]{this.wrap(message)});
        }
    }

    public void sendToClientAll(MinecraftServer server, CreativePacket message) {
        PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{this.wrap(message)});
    }
}

