/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.GuiInfoStackButton;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;

public abstract class CreativeIngredient {
    public static final NamedTypeRegistry<CreativeIngredient> REGISTRY = new NamedTypeRegistry().addConstructorPattern(new Class[0]);
    private static final List<Function<Object, ? extends CreativeIngredient>> objectParsers = new ArrayList<Function<Object, ? extends CreativeIngredient>>();
    private static final CreativeIngredient EMPTY = new CreativeIngredient(){

        @Override
        protected void saveExtra(CompoundTag nbt) {
        }

        @Override
        protected void loadExtra(CompoundTag nbt) {
        }

        @Override
        public boolean is(CreativeIngredient info) {
            return false;
        }

        @Override
        public boolean is(ItemStack stack) {
            return false;
        }

        @Override
        public ItemStack getExample() {
            return ItemStack.EMPTY;
        }

        @Override
        public boolean equals(CreativeIngredient object) {
            return false;
        }

        @Override
        public Component descriptionDetail() {
            return Component.literal((String)"empty");
        }

        @Override
        public Component description() {
            return Component.literal((String)"invalid");
        }

        @Override
        public CreativeIngredient copy() {
            return EMPTY;
        }
    };

    public static <T extends CreativeIngredient> void registerType(String id, Class<T> classType, Function<Object, T> parser) {
        REGISTRY.register(id, classType);
        if (parser != null) {
            objectParsers.add(parser);
        }
    }

    public static CreativeIngredient parse(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CreativeIngredient) {
            return (CreativeIngredient)object;
        }
        for (int i = 0; i < objectParsers.size(); ++i) {
            try {
                CreativeIngredient ingredient = objectParsers.get(i).apply(object);
                if (ingredient == null) continue;
                return ingredient;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static CreativeIngredient load(CompoundTag nbt) {
        Class<CreativeIngredient> classType = REGISTRY.get(nbt.getString("id"));
        if (classType == null) {
            CreativeCore.LOGGER.error((Object)new IllegalArgumentException("'" + nbt.getString("id") + "' is an invalid type"));
            return EMPTY;
        }
        try {
            CreativeIngredient ingredient = classType.getConstructor(new Class[0]).newInstance(new Object[0]);
            ingredient.loadExtra(nbt);
            return ingredient;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("id", REGISTRY.getIdOrDefault(this, "empty"));
        this.saveExtra(nbt);
        return nbt;
    }

    protected abstract void saveExtra(CompoundTag var1);

    protected abstract void loadExtra(CompoundTag var1);

    public abstract boolean is(ItemStack var1);

    public abstract boolean is(CreativeIngredient var1);

    public abstract ItemStack getExample();

    public abstract CreativeIngredient copy();

    public boolean equals(Object object) {
        return object instanceof CreativeIngredient && this.equals((CreativeIngredient)object);
    }

    public abstract boolean equals(CreativeIngredient var1);

    public abstract Component description();

    public abstract Component descriptionDetail();

    static {
        CreativeIngredient.registerType("block", CreativeIngredientBlock.class, x -> {
            Block block = null;
            if (x instanceof Block) {
                block = (Block)x;
            }
            if (x instanceof BlockItem) {
                block = Block.byItem((Item)((Item)x));
            }
            if (block != null && !(block instanceof AirBlock)) {
                return new CreativeIngredientBlock(block);
            }
            return null;
        });
        CreativeIngredient.registerType("blocktag", CreativeIngredientBlockTag.class, x -> {
            TagKey key;
            if (x instanceof TagKey && (key = (TagKey)x).isFor(Registries.BLOCK)) {
                return new CreativeIngredientBlockTag((TagKey<Block>)((TagKey)x));
            }
            return null;
        });
        CreativeIngredient.registerType("item", CreativeIngredientItem.class, x -> {
            if (x instanceof Item && !(x instanceof BlockItem)) {
                return new CreativeIngredientItem((Item)x);
            }
            return null;
        });
        CreativeIngredient.registerType("itemtag", CreativeIngredientItemTag.class, x -> {
            TagKey key;
            if (x instanceof TagKey && (key = (TagKey)x).isFor(Registries.ITEM)) {
                return new CreativeIngredientItemTag((TagKey<Item>)((TagKey)x));
            }
            return null;
        });
        CreativeIngredient.registerType("itemstack", CreativeIngredientItemStack.class, x -> x instanceof ItemStack ? new CreativeIngredientItemStack((ItemStack)x, false) : null);
        CreativeIngredient.registerType("fuel", CreativeIngredientFuel.class, null);
        CreativeIngredientBlock temp = new CreativeIngredientBlock(Blocks.DIRT);
        ConfigTypeConveration.registerSpecialType(CreativeIngredient.class::isAssignableFrom, new ConfigTypeConveration.SimpleConfigTypeConveration<CreativeIngredient>(){

            @Override
            public CreativeIngredient readElement(CreativeIngredient defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    try {
                        return CreativeIngredient.load(TagParser.parseTag((String)element.getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        CreativeCore.LOGGER.error((Object)e);
                    }
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(CreativeIngredient value, CreativeIngredient defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value.save().toString());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz) {
                parent.add(new GuiInfoStackButton("data", CreativeIngredient.this).setExpandableX());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(CreativeIngredient value, GuiParent parent) {
                GuiInfoStackButton button = (GuiInfoStackButton)parent.get("data");
                button.set(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected CreativeIngredient saveValue(GuiParent parent, Class clazz) {
                GuiInfoStackButton button = (GuiInfoStackButton)parent.get("data");
                return button.get();
            }

            @Override
            public CreativeIngredient set(ConfigKey.ConfigKeyField key, CreativeIngredient value) {
                return value;
            }
        });
    }
}

