/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;

public class CreativeIngredientItemStack
extends CreativeIngredient {
    public ItemStack stack;
    public boolean needNBT;

    public CreativeIngredientItemStack(ItemStack stack, boolean needNBT) {
        this.stack = stack;
        this.needNBT = needNBT;
    }

    public CreativeIngredientItemStack() {
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        this.stack.save(nbt);
        nbt.putBoolean("needNBT", this.needNBT);
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        this.stack = ItemStack.of((CompoundTag)nbt);
        this.needNBT = nbt.getBoolean("needNBT");
    }

    @Override
    public boolean is(CreativeIngredient info) {
        if (info instanceof CreativeIngredientItemStack) {
            if (((CreativeIngredientItemStack)info).stack.getItem() != this.stack.getItem()) {
                return false;
            }
            if (((CreativeIngredientItemStack)info).stack.getDamageValue() != this.stack.getDamageValue()) {
                return false;
            }
            return ItemStack.isSameItem((ItemStack)((CreativeIngredientItemStack)info).stack, (ItemStack)this.stack);
        }
        return false;
    }

    @Override
    public boolean is(ItemStack stack) {
        if (stack.getItem() != this.stack.getItem()) {
            return false;
        }
        if (stack.getDamageValue() != this.stack.getDamageValue()) {
            return false;
        }
        return ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)stack);
    }

    @Override
    public ItemStack getExample() {
        return this.stack.copy();
    }

    @Override
    public boolean equals(CreativeIngredient object) {
        return object instanceof CreativeIngredientItemStack && object.is(this.stack);
    }

    @Override
    public CreativeIngredient copy() {
        return new CreativeIngredientItemStack(this.stack.copy(), this.needNBT);
    }

    @Override
    public Component description() {
        return this.stack.getDisplayName();
    }

    @Override
    public Component descriptionDetail() {
        return Component.translatable((String)"minecraft.stack").append(": " + ChatFormatting.YELLOW + this.stack.getDisplayName());
    }
}

