/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;

public class CreativeIngredientItemTag
extends CreativeIngredient {
    public TagKey<Item> tag;

    public CreativeIngredientItemTag(TagKey<Item> tag) {
        this.tag = tag;
    }

    public CreativeIngredientItemTag() {
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        nbt.putString("tag", this.tag.location().toString());
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        this.tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(nbt.getString("tag")));
    }

    @Override
    public boolean is(ItemStack stack) {
        return stack.getItem().builtInRegistryHolder().is(this.tag);
    }

    @Override
    public boolean is(CreativeIngredient info) {
        return info instanceof CreativeIngredientItemTag && ((CreativeIngredientItemTag)info).tag == this.tag;
    }

    @Override
    public ItemStack getExample() {
        Optional optional = BuiltInRegistries.ITEM.getTag(this.tag);
        if (optional.isEmpty() || ((HolderSet.Named)optional.get()).size() == 0) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)((HolderSet.Named)optional.get()).get(0).value());
    }

    @Override
    public boolean equals(CreativeIngredient object) {
        return object instanceof CreativeIngredientItemTag && ((CreativeIngredientItemTag)object).tag == this.tag;
    }

    @Override
    public CreativeIngredient copy() {
        return new CreativeIngredientItemTag(this.tag);
    }

    @Override
    public Component description() {
        return Component.literal((String)this.tag.location().toString());
    }

    @Override
    public Component descriptionDetail() {
        return Component.translatable((String)"minecraft.item_tag").append(": " + ChatFormatting.YELLOW + this.tag.location());
    }
}

